/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.azure.app;

import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.azure.app.AzureSigner;
import de.intarsys.security.device.azure.app.RsaSignatureScheme;
import de.intarsys.security.device.azure.device.AzureDevice;
import de.intarsys.security.device.azure.device.AzurePrincipal;
import de.intarsys.security.device.common.CertificateIdentityPrincipalFilter;
import de.intarsys.security.device.common.PrincipalEqualityPrincipalFilter;
import de.intarsys.security.device.common.PrincipalFilterTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;

public class AzureSignerFactory
extends CommonSignerFactory<AzureDevice, AzureSigner> {
    public static final String ARG_PRINCIPAL_FILTER = "principalFilter";
    public static final String ARG_RSASIGNATURESCHEME = "rsaSignatureScheme";
    private RsaSignatureScheme defaultRsaSignatureScheme = RsaSignatureScheme.PSS;

    protected AzureSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        Iterator principals;
        AzurePrincipal principal = null;
        IPrincipalFilter principalFilter = this.getPrincipalFilter(args, ARG_PRINCIPAL_FILTER);
        if (principalFilter == null) {
            Object sid = args.get("signerIdentifier");
            if (sid instanceof IPrincipal) {
                principalFilter = new PrincipalEqualityPrincipalFilter((IPrincipal)((AzurePrincipal)((Object)sid)));
            } else {
                IX509PublicKeyCertificate certificate = this.getCertificate(args, "signerIdentifier");
                principalFilter = new CertificateIdentityPrincipalFilter((IX509Certificate)certificate);
            }
        }
        if (!(principals = ((AzureDevice)this.getDevice(args)).listPrincipals(principalFilter)).hasNext()) {
            throw new ObjectCreationException("no principal found");
        }
        principal = (AzurePrincipal)((Object)principals.next());
        AzureSigner app = new AzureSigner((AzureDevice)this.getDevice(args), principal);
        app.buildCertificatePath();
        Object rsaSignatureScheme = ArgTools.getObject((IArgs)args, (String)ARG_RSASIGNATURESCHEME, (Object)((Object)this.getDefaultRsaSignatureScheme()));
        app.setRsaSignatureScheme(RsaSignatureScheme.create(rsaSignatureScheme));
        return app;
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    public RsaSignatureScheme getDefaultRsaSignatureScheme() {
        return this.defaultRsaSignatureScheme;
    }

    protected IPrincipalFilter getPrincipalFilter(IArgs args, String name) throws ObjectCreationException {
        Object value = args.get(name);
        return PrincipalFilterTools.createFilter((Object)value);
    }

    public Class<AzureSigner> getResultType() {
        return AzureSigner.class;
    }

    public void setDefaultRsaSignatureScheme(RsaSignatureScheme rsaSignatureScheme) {
        this.defaultRsaSignatureScheme = rsaSignatureScheme;
    }

    public void setDefaultRsaSignatureScheme(String rsaSignatureScheme) {
        this.setDefaultRsaSignatureScheme(rsaSignatureScheme);
    }
}

