/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.azure.credential;

import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import de.intarsys.security.device.azure.credential.PACKAGE;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSecretCredentialFactory
extends CommonInstantiatingFactory<ClientSecretCredential> {
    private static final Logger Log = LoggerFactory.getLogger(ClientSecretCredentialFactory.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String ARG_CLIENT_ID = "clientId";
    public static final String ARG_CLIENT_SECRET = "clientSecret";
    public static final String ARG_TENANT_ID = "tenantId";

    protected ClientSecretCredential basicCreateInstance(IArgs args) throws ObjectCreationException {
        String tenantId = ArgTools.getString((IArgs)args, (String)ARG_TENANT_ID, null);
        if (StringTools.isEmpty((String)tenantId)) {
            throw new ObjectCreationException("Missing tenant ID");
        }
        String clientId = ArgTools.getString((IArgs)args, (String)ARG_CLIENT_ID, null);
        if (StringTools.isEmpty((String)clientId)) {
            throw new ObjectCreationException("Missing client ID");
        }
        Secret clientSecret = ArgTools.getSecretHide((IArgs)args, (String)ARG_CLIENT_SECRET, null);
        if (clientSecret == null) {
            throw new ObjectCreationException("Missing client secret");
        }
        try {
            return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(tenantId)).clientId(clientId)).clientSecret(clientSecret.getString()).build();
        }
        catch (GeneralSecurityException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    public Class<ClientSecretCredential> getResultType() {
        return ClientSecretCredential.class;
    }
}

