/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.azure.device;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.keys.KeyClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.azure.credential.ClientSecretCredentialFactory;
import de.intarsys.security.device.azure.device.AzureDeviceProvider;
import de.intarsys.security.device.azure.device.AzurePrincipal;
import de.intarsys.security.device.azure.device.PACKAGE;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.cert.CertificateException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=AzureDeviceProvider.class)
public class AzureDevice
extends CommonDevice<AzureDeviceProvider> {
    public static final String ARG_KEYVAULT_URL = "keyVaultUrl";
    public static final String ARG_CREDENTIAL = "credential";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(AzureDevice.class);
    public static final String LIC_PRODUCT = "de.intarsys.security.device.azure";
    private IArgs args;
    private String keyVaultUrl;
    private CertificateClient certificateClient;
    private KeyClient keyClient;
    private TokenCredential credential;

    protected AzureDevice(AzureDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    protected KeyVaultCertificate azureGetCertificate(String certificateName) {
        return this.getCertificateClient().getCertificate(certificateName);
    }

    protected ISecurityApplication basicCreateApplication(Class<ISecurityApplication> clazz, IArgs args) throws ObjectCreationException {
        ISecurityApplication app = super.basicCreateApplication(clazz, args);
        this.triggerEvent((Event)new CreatedEvent((Object)this, (Object)app));
        return app;
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        this.setKeyVaultUrl(ArgTools.getString((IArgs)args, (String)ARG_KEYVAULT_URL, null));
        this.credential = this.createCredential(args);
        this.certificateClient = new CertificateClientBuilder().vaultUrl(this.getKeyVaultUrl()).credential(this.credential).buildClient();
        this.keyClient = new KeyClientBuilder().vaultUrl(this.getKeyVaultUrl()).credential(this.credential).buildClient();
    }

    protected IX509PublicKeyCertificate[] createCertificateChain(String certificateName) throws SecurityApplicationException {
        IX509PublicKeyCertificate[] certificatePath;
        IX509PublicKeyCertificate certificate;
        KeyVaultCertificate kvCertificate = this.azureGetCertificate(certificateName);
        try {
            certificate = (IX509PublicKeyCertificate)CertificateTools.createCertificate((Object)kvCertificate.getCer());
        }
        catch (CertificateException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        IX509Certificate[] path = ValidationTools.getCertificatePath((IX509Certificate)certificate);
        if (path == null || path.length == 0) {
            certificatePath = new IX509PublicKeyCertificate[]{certificate};
        } else {
            certificatePath = new IX509PublicKeyCertificate[path.length];
            System.arraycopy(path, 0, certificatePath, 0, path.length);
        }
        return certificatePath;
    }

    protected TokenCredential createCredential(IArgs args) throws ObjectCreationException {
        DefaultAzureCredential tokenCredential;
        Object credential = ArgTools.getPath((IArgs)args, (String)ARG_CREDENTIAL);
        if (credential == null) {
            tokenCredential = new DefaultAzureCredentialBuilder().build();
        } else if (credential instanceof TokenCredential) {
            tokenCredential = (TokenCredential)credential;
        } else {
            InstanceSpec credentialSpec = InstanceSpec.createFromArgs(TokenCredential.class, (Object)credential);
            if (credentialSpec.getFactory() == null) {
                credentialSpec.setFactory(ClientSecretCredentialFactory.class);
            }
            tokenCredential = (TokenCredential)credentialSpec.createInstance();
        }
        Log.info("Logging in to Azure using {}.", (Object)tokenCredential.getClass().getSimpleName());
        return tokenCredential;
    }

    protected String createLabel() {
        return Msg.getString("AzureDevice.label", new Object[0]);
    }

    protected void ensurePrincipalsAvailable() {
        super.ensurePrincipalsAvailable();
        PagedIterable propertiesOfCertificates = this.getCertificateClient().listPropertiesOfCertificates();
        List<IPrincipal> principals = propertiesOfCertificates.stream().map(cp -> new AzurePrincipal((IDevice)this, (CertificateProperties)cp)).map(IPrincipal.class::cast).toList();
        this.setPrincipals(principals);
    }

    public IArgs getArgs() {
        return this.args;
    }

    public CertificateClient getCertificateClient() {
        return this.certificateClient;
    }

    public CryptographyClient getCryptographyClient(String keyName) {
        return this.getKeyClient().getCryptographyClient(keyName);
    }

    public KeyClient getKeyClient() {
        return this.keyClient;
    }

    public String getKeyVaultUrl() {
        return this.keyVaultUrl;
    }

    public void setCertificateClient(CertificateClient certificateClient) {
        this.certificateClient = certificateClient;
    }

    public void setKeyClient(KeyClient keyClient) {
        this.keyClient = keyClient;
    }

    public void setKeyVaultUrl(String keyVaultUrl) {
        this.keyVaultUrl = keyVaultUrl;
    }
}

