/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.azure.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.azure.app.AzureSignerFactory;
import de.intarsys.security.device.azure.device.AzureDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class AzureDeviceProvider
extends CommonDeviceProvider<AzureDevice> {
    private final CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);

    public AzureDeviceProvider() {
        super("azure");
    }

    protected AzureDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        AzureDevice device = new AzureDevice(this, this.getId(args));
        return device;
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        AzureSignerFactory descriptor = new AzureSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        descriptor.setPolicy((IApplicationPolicy)this.signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(-1, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.azure");
    }

    @PostConstruct
    public void init() {
        super.init();
        IElement policyElement = ElementTools.getPathElement((IElement)this.getConfiguration(), (String[])new String[]{"policies", "signer"});
        if (policyElement != null) {
            try {
                this.signerPolicy.configure(policyElement);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

