/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.azure.device;

import com.azure.security.keyvault.certificates.models.CertificateProperties;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.azure.device.AzureDevice;
import de.intarsys.security.device.azure.device.AzurePrincipalWrapper;
import de.intarsys.security.device.common.CommonX509Principal;
import de.intarsys.tools.facade.IFacade;
import de.intarsys.tools.facade.IFacadeSupport;
import de.intarsys.tools.lang.LangTools;

public class AzurePrincipal
extends CommonX509Principal
implements IFacadeSupport {
    private final CertificateProperties certificateProperties;
    private IX509PublicKeyCertificate[] certificatePath;

    public AzurePrincipal(IDevice device, CertificateProperties certificateProperties) {
        super(device, null, certificateProperties.getName());
        this.certificateProperties = certificateProperties;
    }

    protected IX509PublicKeyCertificate createCertificate() {
        try {
            IX509PublicKeyCertificate[] certs = this.getCertificatePath();
            if (certs.length > 0) {
                return certs[0];
            }
        }
        catch (SecurityApplicationException securityApplicationException) {
            // empty catch block
        }
        return null;
    }

    public IFacade createFacade() {
        return new AzurePrincipalWrapper((IPrincipal)this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AzurePrincipal)) {
            return false;
        }
        return LangTools.equals((Object)this.getCertificateProperties().getName(), (Object)((AzurePrincipal)((Object)obj)).getCertificateProperties().getName()) && LangTools.equals((Object)this.getCertificateProperties().getVersion(), (Object)((AzurePrincipal)((Object)obj)).getCertificateProperties().getVersion());
    }

    public String getCertificateName() {
        return this.getCertificateProperties().getName();
    }

    public IX509PublicKeyCertificate[] getCertificatePath() throws SecurityApplicationException {
        if (this.certificatePath == null) {
            this.certificatePath = this.getDevice().createCertificateChain(this.getCertificateName());
        }
        return this.certificatePath;
    }

    public CertificateProperties getCertificateProperties() {
        return this.certificateProperties;
    }

    public AzureDevice getDevice() {
        return (AzureDevice)super.getDevice();
    }

    public int hashCode() {
        return this.getCertificateProperties().hashCode();
    }

    public void setCertificatePath(IX509PublicKeyCertificate[] certificatePath) {
        this.certificatePath = certificatePath;
    }
}

