/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.common;

import de.intarsys.security.app.DisposedException;
import de.intarsys.security.app.IApplication;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.IDevice;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.ObjectTools;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractApplication
implements IApplication,
IPresentationSupport {
    private final IDevice device;
    private final long creationTime;
    private final String id = ObjectTools.createLabel((Object)this);
    protected final Object lock = new Object();
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private IApplicationDescriptor<?> descriptor;
    private final EventDispatcher dispatcher;

    public AbstractApplication(IDevice device) {
        if (device == null) {
            throw new NullPointerException("device cannot be null");
        }
        this.device = device;
        this.creationTime = System.currentTimeMillis();
        this.dispatcher = new EventDispatcher((Object)this);
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected void basicDispose() {
    }

    protected IDevice basicGetDevice() {
        return this.device;
    }

    protected boolean basicIsDisposed() {
        return this.disposed.get();
    }

    protected void basicReset() {
    }

    protected void checkDispose() throws SecurityApplicationException {
        if (this.isDisposed()) {
            throw new DisposedException();
        }
    }

    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        this.basicDispose();
        this.dispatcher.clear();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDescription() {
        return this.getTip();
    }

    public IApplicationDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public IDevice getDevice() {
        return this.device;
    }

    public String getIconName() {
        return "security/application";
    }

    protected String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.id;
    }

    public String getTip() {
        return this.getLabel();
    }

    @PostConstruct
    public void init() {
    }

    @Override
    public boolean isDisposed() {
        return this.basicIsDisposed();
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public final void reset() {
        this.basicReset();
    }

    public void setDescriptor(IApplicationDescriptor<?> descriptor) {
        this.descriptor = descriptor;
    }

    public String toString() {
        return this.getId();
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        this.dispatcher.triggerChanged(attribute, oldValue, newValue);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }
}

