/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.common;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.IRestrictedApplication;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.AbstractSecurityApplication;
import de.intarsys.security.device.IDevice;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.ILicenseAccountSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import java.util.Objects;

public abstract class DelegatingSecurityApplication<T extends ISecurityApplication>
extends AbstractSecurityApplication
implements IAdapterSupport,
IStringEvaluator {
    private final T wrapped;

    protected DelegatingSecurityApplication(IDevice device, T wrapped) {
        super(device);
        Objects.requireNonNull(wrapped, "wrapped cannot be null");
        this.wrapped = wrapped;
        if (wrapped.isDisposed()) {
            this.dispose();
        }
    }

    @Override
    public IConversation<Void> authenticate() {
        try {
            this.checkDispose();
        }
        catch (ApplicationException e) {
            return Conversation.failed((Throwable)e);
        }
        return ((IAuthenticatedApplication)this.wrapped).authenticate();
    }

    @Override
    protected void basicDispose() {
        super.basicDispose();
        this.basicDisposeLocal();
        this.basicDisposeWrapped();
    }

    protected void basicDisposeLocal() {
    }

    protected void basicDisposeWrapped() {
        this.wrapped.dispose();
    }

    protected String basicGetLabel() {
        return this.getClass().getName();
    }

    @Override
    protected void basicReset() {
        super.basicReset();
        this.basicResetLocal();
        this.basicResetWrapped();
    }

    protected void basicResetLocal() {
    }

    protected void basicResetWrapped() {
        this.wrapped.reset();
    }

    @Override
    public void deauthenticate() throws SecurityApplicationException {
        this.checkDispose();
        ((IAuthenticatedApplication)this.wrapped).deauthenticate();
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        T t = this.wrapped;
        if (t instanceof IStringEvaluator) {
            IStringEvaluator evaluator = (IStringEvaluator)t;
            return evaluator.evaluate(expression, args);
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    public <A> A getAdapter(Class<A> clazz) {
        return (A)AdapterTools.getAdapter(this.getWrapped(), clazz, null);
    }

    @Override
    public String getAuthenticationPrompt() {
        return ((IAuthenticatedApplication)this.wrapped).getAuthenticationPrompt();
    }

    @Override
    public String getDescription() {
        if (this.getWrapped() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getWrapped()).getDescription();
        }
        return this.getTip();
    }

    @Override
    public String getIconName() {
        if (this.getWrapped() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getWrapped()).getIconName();
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.getWrapped() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getWrapped()).getLabel();
        }
        return this.basicGetLabel();
    }

    public ILicenseAccount getLicenseAccount() {
        if (this.wrapped instanceof ILicenseAccountSupport) {
            return ((ILicenseAccountSupport)this.wrapped).getLicenseAccount();
        }
        return null;
    }

    @Override
    public IPasswordProvider getPasswordProvider() {
        return ((IAuthenticatedApplication)this.wrapped).getPasswordProvider();
    }

    @Override
    public int getRestrictionCount() {
        return ((IRestrictedApplication)this.wrapped).getRestrictionCount();
    }

    @Override
    public long getRestrictionTime() {
        return ((IRestrictedApplication)this.wrapped).getRestrictionTime();
    }

    @Override
    public String getTip() {
        if (this.getWrapped() instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.getWrapped()).getTip();
        }
        return this.getLabel();
    }

    @Override
    public int getUseCount() {
        return this.wrapped.getUseCount();
    }

    @Override
    public long getUseTime() {
        return this.wrapped.getUseTime();
    }

    public T getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isDisposed() {
        return super.isDisposed() || this.wrapped.isDisposed();
    }

    @Override
    public boolean isValid() {
        return !this.basicIsDisposed() && this.wrapped.isValid();
    }

    @Override
    public void setAuthenticationPin(Secret pin) {
        ((IAuthenticatedApplication)this.wrapped).setAuthenticationPin(pin);
    }

    @Override
    public void setAuthenticationPrompt(String prompt) {
        ((IAuthenticatedApplication)this.wrapped).setAuthenticationPrompt(prompt);
    }

    @Override
    public void setPasswordProvider(IPasswordProvider provider) {
        ((IAuthenticatedApplication)this.wrapped).setPasswordProvider(provider);
    }

    @Override
    public void setRestrictionCount(int restrictionCount) {
        ((IRestrictedApplication)this.wrapped).setRestrictionCount(restrictionCount);
    }

    @Override
    public void setRestrictionTime(long restrictionTime) {
        ((IRestrictedApplication)this.wrapped).setRestrictionTime(restrictionTime);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }
}

