/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.crypt.symmetric.common;

import de.intarsys.security.app.crypt.IKeyEncryptedData;
import de.intarsys.security.app.crypt.KeyEncryptedData;
import de.intarsys.security.app.crypt.symmetric.common.AbstractCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricDecryptorException;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricEncryptorException;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class CommonCryptHandler
extends AbstractCryptHandler {
    protected CommonCryptHandler(CommonDevice device) throws ObjectCreationException {
        super(device);
    }

    protected AlgorithmParameters decodeAlgorithmParameters(byte[] encoded) throws GeneralSecurityException, IOException {
        return null;
    }

    @Override
    public byte[] decrypt(IKeyEncryptedData encryptedData) throws SymmetricDecryptorException {
        InputStream is = null;
        try {
            is = encryptedData.getLocator().getInputStream();
            byte[] encryptedBytes = StreamTools.toByteArray((InputStream)is);
            byte[] key = encryptedData.getKey();
            Cipher cipher = Cipher.getInstance(this.getCipherAlgorithm(), this.getProvider());
            byte[] param = encryptedData.getAlgorithmParameters();
            AlgorithmParameters parameters = null;
            if (param != null) {
                parameters = this.decodeAlgorithmParameters(param);
            }
            SecretKey skeySpec = this.parseKey(key);
            cipher.init(2, (Key)skeySpec, parameters);
            byte[] byArray = cipher.doFinal(encryptedBytes);
            return byArray;
        }
        catch (IOException e) {
            throw new SymmetricDecryptorException(e);
        }
        catch (GeneralSecurityException e) {
            throw new SymmetricDecryptorException(e);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    protected byte[] encodeAlgorithmParameters(AlgorithmParameters parameters) throws GeneralSecurityException, IOException {
        return null;
    }

    @Override
    public IKeyEncryptedData encrypt(byte[] data) throws SymmetricEncryptorException {
        return this.encrypt(data, this.generateKey());
    }

    @Override
    public IKeyEncryptedData encrypt(byte[] data, SecretKey key) throws SymmetricEncryptorException {
        try {
            Cipher cipher = Cipher.getInstance(this.getCipherAlgorithm(), this.getProvider());
            AlgorithmParameters parameters = this.generateAlgorithmParameters(cipher);
            cipher.init(1, (Key)key, parameters);
            byte[] encryptedData = cipher.doFinal(data);
            byte[] param = null;
            if (parameters != null) {
                param = this.encodeAlgorithmParameters(parameters);
            }
            KeyEncryptedData result = new KeyEncryptedData((ILocator)new ByteArrayLocator(encryptedData, "encrypted", "unknown"), this.getAlgorithmOID(), key.getEncoded(), param);
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new SymmetricEncryptorException(e);
        }
        catch (IOException e) {
            throw new SymmetricEncryptorException(e);
        }
    }

    protected AlgorithmParameters generateAlgorithmParameters(Cipher cipher) throws GeneralSecurityException {
        return null;
    }

    @Override
    public SecretKey generateKey() throws SymmetricEncryptorException {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(this.getKeyAlgorithm(), this.getProvider());
            keyGen.init(this.getKeyLength());
            return keyGen.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new SymmetricEncryptorException(e);
        }
    }

    protected abstract String getCipherAlgorithm();

    @Override
    public abstract String getKeyAlgorithm();

    protected String getProvider() {
        return "BC";
    }

    @Override
    public SecretKey parseKey(byte[] key) throws SymmetricDecryptorException {
        return new SecretKeySpec(key, this.getKeyAlgorithm());
    }
}

