/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.decryption;

import de.intarsys.security.app.PermissionDenied;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.app.decryption.PACKAGE;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.monitor.Trace;
import de.intarsys.tools.string.StringTools;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonDecryptor
extends CommonSecurityApplication
implements IDecryptor {
    private static IMessageBundle Msg = PACKAGE.Messages;
    public static final String LIC_PROPERTY_APP_DECRYPT = "de.intarsys.security.app.decrypt.account";
    private static final Logger Log = LoggerFactory.getLogger(CommonDecryptor.class);

    public CommonDecryptor(CommonDevice device) {
        super(device);
    }

    protected abstract IDecryptedData basicDecrypt(IEncryptedData var1) throws SecurityApplicationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IDecryptedData decrypt(IEncryptedData encryptedData) throws SecurityApplicationException {
        try {
            Trace.get().sample(Level.INFO, "enter decryptor ");
            try {
                this.licenseWithdraw();
            }
            catch (LicenseException e) {
                String msg = Msg.getString("CommonDecryptor.ExLicense", new Object[0]);
                throw new SecurityApplicationException(msg, e);
            }
            if (!this.isAuthenticated()) {
                throw new PermissionDenied("not authenticated");
            }
            if (!this.checkRestriction()) {
                this.deauthenticate();
                try {
                    this.authenticate().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SecurityApplicationException("execution interrupted", e);
                }
                catch (ExecutionException e) {
                    throw (SecurityApplicationException)ExceptionTools.createTypedFromChain((Throwable)e, SecurityApplicationException.class);
                }
            }
            IDecryptedData result = this.basicDecrypt(encryptedData);
            Log.info("{} finished ", (Object)StringTools.safeString((Object)this));
            this.incUseCount();
            IDecryptedData iDecryptedData = result;
            return iDecryptedData;
        }
        finally {
            Trace.get().sample(Level.INFO, "leave decryptor ");
        }
    }

    @Override
    public IX509Certificate getCertificate() {
        return null;
    }

    @Override
    protected String getPublishCodePrefix() {
        return "decrypt";
    }
}

