/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.IAuthenticationEvidence;
import de.intarsys.security.app.PermissionDenied;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.PACKAGE;
import de.intarsys.security.app.signature.SignatureEvidence;
import de.intarsys.security.app.signature.SignatureItemEvidence;
import de.intarsys.security.app.signature.SignerSerializer;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.audit.v2.core.Audit;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.ISignatureDataList;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureDataList;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.ResolveProperty;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.json.JsonWriter;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=SignerSerializer.class)
public abstract class CommonSigner
extends CommonSecurityApplication
implements ISigner {
    public static final String ARG_APPROXIMATED_CONTAINER_SIZE = "approximatedContainerSize";
    public static final int DEFAULT_APPROXIMATED_CONTAINER_SIZE = 16384;
    protected static final int MAX_PDFA_CONFORMANT_CONTAINER_SIZE = Short.MAX_VALUE;
    public static final String LIC_PROPERTY_APP_SIGN = "de.intarsys.security.app.sign.account";
    public static final String LIC_PROPERTY_APP_DECRYPT = "de.intarsys.security.app.decrypt.account";
    private static IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CommonSigner.class);
    private SignatureFormat signatureFormat;
    private SignatureOptions signatureOptions = SignatureOptions.NONE;
    private String hashAlgorithmName;
    private IX509PublicKeyCertificate[] certificatePath;
    private String signatureLabel;
    private IAuthenticationEvidence authorizationEvidence;
    private SignatureEvidence signatureEvidence;
    private IAuthenticationContext authorizationContext;
    private boolean batchMode;
    private String processingMessage;
    private List<SignatureTask> tasks;
    private final AtomicInteger counter = new AtomicInteger();
    private IConversation<Void> conversationSignPrepare;
    private int approximatedContainerSize = 16384;
    private AlgorithmParameterSpec algorithmParameterSpec;

    protected CommonSigner(CommonDevice device) {
        super(device);
    }

    @Override
    protected void basicReset() {
        super.basicReset();
        this.tasksRelease();
    }

    protected IConversation<Void> basicSignAbort() {
        return Conversation.completed(null);
    }

    protected IConversation<Void> basicSignAuthorize() {
        this.basicSignCheckAccess();
        if (this.getAuthorizationContext() == null) {
            return Conversation.completed(null);
        }
        return this.getAuthorizationContext().authenticate(this.createAuthorizationArgs());
    }

    protected abstract IConversation<?> basicSignAuthorized();

    protected IConversation<Void> basicSignBegin() {
        return Conversation.completed(null);
    }

    protected void basicSignCheckAccess() {
        SignerTools.checkAccess(this.getDevice());
    }

    protected IConversation<?> basicSignCommit() {
        return this.basicSignAuthorize().thenCompose(ignore -> {
            if (!this.isAuthenticated()) {
                throw new PermissionDenied("not authenticated");
            }
            this.setAuthorizationEvidence(null);
            this.licenseReserve(this.tasksSize());
            return this.basicSignAuthorized();
        });
    }

    protected IConversation<Void> basicSignPrepare() {
        if (this.conversationSignPrepare == null) {
            this.conversationSignPrepare = this.createConversationSignPrepare();
        }
        return this.conversationSignPrepare;
    }

    protected IConversation<ISignatureData> basicSignTaskAdd(IToBeSignedData data) {
        SignatureTask task = this.createSignatureTask(data);
        if (this.isBatchMode()) {
            this.tasksAdd(task);
            return task.conversation;
        }
        return this.signBegin().thenCompose(ignore -> {
            this.tasksAdd(task);
            return this.signCommit().thenApply(list -> list.getSignatures().stream().findFirst().orElse(null));
        });
    }

    protected IConversation<Void> basicSignTaskCheck(IToBeSignedData data) {
        return Conversation.completed(null);
    }

    @Override
    public void buildCertificatePath() {
        if (this.getCertificate() == null) {
            this.certificatePath = new IX509PublicKeyCertificate[0];
            return;
        }
        IX509Certificate[] path = ValidationTools.getCertificatePath((IX509Certificate)this.getCertificate());
        if (path == null || path.length == 0) {
            this.certificatePath = new IX509PublicKeyCertificate[]{this.getCertificate()};
        } else {
            this.certificatePath = new IX509PublicKeyCertificate[path.length];
            System.arraycopy(path, 0, this.certificatePath, 0, path.length);
        }
    }

    protected void createAuditEntryFailure() {
    }

    protected void createAuditEntrySuccess() {
        try {
            HashMap<String, Object> msgParams = new HashMap<String, Object>();
            msgParams.put("tx", "signature");
            IX509PublicKeyCertificate cert = this.getCertificate();
            if (cert != null) {
                msgParams.put("sub", cert.getSubjectX500Principal().getName());
            }
            if (this.getSignatureEvidence() != null) {
                msgParams.put("sigEvd", this.getSignatureEvidence().toMap());
            }
            if (this.getAuthorizationEvidence() != null) {
                msgParams.put("authEvd", this.getAuthorizationEvidence().toMap());
            }
            String message = JsonWriter.toString(msgParams, (int)1, (int)1);
            if (Audit.get() != null) {
                Audit.get().log(message);
            }
        }
        catch (Exception e) {
            Log.warn("{} failed to write audit entry", (Object)this, (Object)e);
        }
    }

    protected IArgs createAuthorizationArgs() {
        Args authArgs = Args.create();
        if (this.getSignatureEvidence() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<b>");
            sb.append(Msg.getString("CommonSigner.authorize.message", new Object[0]));
            sb.append("</b></br></br>");
            sb.append("<ul>");
            for (SignatureItemEvidence item : this.getSignatureEvidence().getItems()) {
                sb.append("<li>");
                sb.append(item.getLabel());
                sb.append("</li>");
            }
            sb.append("</ul>");
            authArgs.put("description", (Object)sb.toString());
        }
        return authArgs;
    }

    protected IConversation<Void> createConversationSignPrepare() {
        return Conversation.completed(null);
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return null;
    }

    protected SignatureTask createSignatureTask(IToBeSignedData data) {
        SignatureTask task = new SignatureTask();
        task.index = this.counter.getAndIncrement();
        task.toBeSignedData = data;
        task.conversation = new Conversation("signature-task-" + task.index);
        return task;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    @Override
    public int getApproximatedContainerSize() {
        return this.approximatedContainerSize;
    }

    public IAuthenticationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    public IAuthenticationEvidence getAuthorizationEvidence() {
        return this.authorizationEvidence;
    }

    @Override
    public IX509PublicKeyCertificate getCertificate() {
        IX509PublicKeyCertificate[] tmpPath = this.getCertificatePath();
        return tmpPath == null || tmpPath.length == 0 ? null : tmpPath[0];
    }

    @Override
    public IX509PublicKeyCertificate[] getCertificatePath() {
        return this.certificatePath;
    }

    protected IConversation<Void> getConversationSignPrepare() {
        return this.conversationSignPrepare;
    }

    @Override
    public String getHashAlgorithmName() {
        return this.hashAlgorithmName;
    }

    @Override
    public String getIconName() {
        return "security/signer";
    }

    protected int getKeyBitSize() {
        if (this.getCertificate() == null) {
            return 0;
        }
        return this.getCertificate().getKeyBitSize();
    }

    protected int getKeyByteSize() {
        if (this.getCertificate() == null) {
            return 0;
        }
        int bitSize = this.getCertificate().getKeyBitSize();
        return (bitSize + 7) / 8;
    }

    @Override
    public String getLabel() {
        return "Signature application";
    }

    @Override
    public String getPreferredHashAlgorithmName() {
        return null;
    }

    @Override
    public IPrincipal getPrincipal() {
        IX509PublicKeyCertificate certificate = this.getCertificate();
        if (certificate == null) {
            return null;
        }
        return this.createPrincipal(certificate);
    }

    public String getProcessingMessage() {
        return this.processingMessage;
    }

    protected String getProcessingMessageDefault() {
        return Msg.getString("CommonSigner.processing.message", new Object[]{this.getTasks().size()});
    }

    public String getProcessingMessageExpanded() {
        String msg = this.getProcessingMessage();
        if (StringTools.isEmpty((String)msg)) {
            msg = this.getProcessingMessageDefault();
        }
        return this.expand(msg);
    }

    @Override
    protected String getPublishCodePrefix() {
        return "sign";
    }

    public SignatureEvidence getSignatureEvidence() {
        return this.signatureEvidence;
    }

    @Override
    public SignatureFormat getSignatureFormat() {
        return this.signatureFormat;
    }

    @ResolveProperty(property="signatureLabel")
    public String getSignatureLabel() {
        if (this.signatureLabel == null) {
            return Msg.getString("CommonSigner.signatureLabelDefault", new Object[0]);
        }
        return this.signatureLabel;
    }

    public SignatureOptions getSignatureOptions() {
        return this.signatureOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SignatureTask> getTasks() {
        Object object = this.lock;
        synchronized (object) {
            return this.tasks == null ? List.of() : List.copyOf(this.tasks);
        }
    }

    protected boolean isBatchMode() {
        return this.batchMode;
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    public void setApproximatedContainerSize(int approximatedContainerSize) {
        this.approximatedContainerSize = approximatedContainerSize;
    }

    public void setAuthorizationContext(IAuthenticationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }

    public void setAuthorizationEvidence(IAuthenticationEvidence authorizationEvidence) {
        this.authorizationEvidence = authorizationEvidence;
    }

    protected void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    protected void setCertificatePath(IX509PublicKeyCertificate[] certificatePath) {
        this.certificatePath = certificatePath;
    }

    protected void setConversationSignPrepare(IConversation<Void> conversationPrepare) {
        this.conversationSignPrepare = conversationPrepare;
    }

    @Override
    public void setHashAlgorithmName(String hashAlgorithmName) throws SecurityApplicationException {
        this.hashAlgorithmName = hashAlgorithmName;
    }

    public void setProcessingMessage(String value) {
        this.processingMessage = value;
    }

    public void setSignatureEvidence(SignatureEvidence signatureEvidence) {
        this.signatureEvidence = signatureEvidence;
    }

    @Override
    public void setSignatureFormat(SignatureFormat family) {
        this.signatureFormat = family;
    }

    public void setSignatureLabel(String signatureLabel) {
        this.signatureLabel = signatureLabel;
    }

    @Override
    public void setSignatureOptions(SignatureOptions signatureOptions) {
        if (signatureOptions == null) {
            throw new IllegalArgumentException("'signatureOptions' cannot be null");
        }
        this.signatureOptions = signatureOptions;
    }

    @Override
    public final IConversation<ISignatureData> sign(IToBeSignedData data) {
        return this.basicSignTaskCheck(data).thenCompose(ignore -> this.basicSignTaskAdd(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IConversation<Void> signAbort() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isBatchMode()) {
                return Conversation.failed((Throwable)new SecurityApplicationException("not in batch mode"));
            }
            this.tasksRelease();
        }
        return this.basicSignAbort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IConversation<Void> signBegin() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBatchMode()) {
                return Conversation.failed((Throwable)new SecurityApplicationException("batch mode already started"));
            }
            this.tasksAcquire();
        }
        return this.basicSignBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IConversation<ISignatureDataList> signCommit() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isBatchMode()) {
                return Conversation.failed((Throwable)new SecurityApplicationException("not in batch mode"));
            }
        }
        return this.basicSignCommit().thenApply(ignore -> {
            this.licenseBookingCommit();
            this.createAuditEntrySuccess();
            this.publishOk();
            ISignatureDataList signatures = this.tasksGetSignatureDataList();
            this.tasksRelease();
            return signatures;
        }).exceptionally(ex -> {
            Throwable tmpEx = ExceptionTools.unwrap((Throwable)ex);
            this.licenseBookingAbort();
            this.createAuditEntryFailure();
            if (ExceptionTools.isCancellation((Throwable)ex)) {
                this.publishCancel();
                this.tasksCancel();
            } else {
                this.publishFail(tmpEx);
                this.tasksCompleteExceptionally(tmpEx);
            }
            this.sendNotificationFailed(tmpEx);
            this.tasksRelease();
            throw Conversation.rethrowable((Throwable)ex);
        });
    }

    @Override
    public final IConversation<Void> signPrepare() {
        return this.basicSignPrepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tasksAcquire() {
        Object object = this.lock;
        synchronized (object) {
            this.setBatchMode(true);
            this.tasks = new ArrayList<SignatureTask>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tasksAdd(SignatureTask task) {
        Object object = this.lock;
        synchronized (object) {
            this.tasks.add(task);
        }
    }

    protected void tasksCancel() {
        this.getTasks().stream().forEach(this::tasksCancel);
    }

    protected void tasksCancel(SignatureTask task) {
        Log.info("{} canceled {}", (Object)StringTools.safeString((Object)this), (Object)task);
        task.conversation.cancel(false);
    }

    protected void tasksComplete(List<ISignatureData> signatures) throws SecurityApplicationException {
        List<SignatureTask> tempTasks = this.getTasks();
        if (tempTasks == null) {
            throw new IllegalStateException("tasks not initialized");
        }
        if (signatures.size() != tempTasks.size()) {
            throw new SecurityApplicationException("device returned " + signatures.size() + " signatures, but " + tempTasks.size() + " were requested.");
        }
        Iterator<ISignatureData> iSignature = signatures.iterator();
        tempTasks.stream().forEach(task -> this.tasksComplete((SignatureTask)task, (ISignatureData)iSignature.next()));
    }

    protected void tasksComplete(SignatureTask task, ISignatureData signature) {
        this.incUseCount();
        Log.debug("{} signed {}", (Object)StringTools.safeString((Object)this), (Object)task);
        task.signatureData = signature;
        task.conversation.complete((Object)task.signatureData);
    }

    protected void tasksCompleteExceptionally(SignatureTask task, Throwable e) {
        if (!task.conversation.isDone()) {
            Log.info("{} failed {}", (Object)StringTools.safeString((Object)this), (Object)task);
            task.conversation.completeExceptionally(e);
        }
    }

    protected void tasksCompleteExceptionally(Throwable ex) {
        this.getTasks().stream().forEach(task -> this.tasksCompleteExceptionally((SignatureTask)task, ex));
    }

    protected ISignatureDataList tasksGetSignatureDataList() {
        List<ISignatureData> signatures = this.getTasks().stream().map(task -> task.signatureData).toList();
        return SignatureDataList.create(signatures);
    }

    protected List<IToBeSignedData> tasksGetToBeSignedData() {
        return this.getTasks().stream().map(task -> task.toBeSignedData).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tasksRelease() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tasks != null) {
                for (SignatureTask task : this.tasks) {
                    if (task.conversation.isDone()) continue;
                    task.conversation.cancel(false);
                }
            }
            this.setBatchMode(false);
            this.tasks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int tasksSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.tasks == null ? 0 : this.tasks.size();
        }
    }
}

