/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.method.common.signature.ISignatureContainerBuilder;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureContainerEntryReviewer
implements ISignatureContainerEntryProcessor {
    private static final Logger Log = LoggerFactory.getLogger(SignatureContainerEntryReviewer.class);
    private final IReviewer<ISignatureEntry, IVSSignatureEntry> signatureReviewer;

    public SignatureContainerEntryReviewer(IReviewer<ISignatureEntry, IVSSignatureEntry> signatureReviewer) {
        this.signatureReviewer = signatureReviewer;
    }

    public IReviewer<ISignatureEntry, IVSSignatureEntry> getSignatureReviewer() {
        return this.signatureReviewer;
    }

    public void process(ISignatureContainerBuilder builder, ISignatureContainerEntry entry, ISignatureData signatureData) throws SecurityApplicationException, IOException {
        if (!(entry instanceof ISignatureEntry)) {
            throw new SecurityApplicationException("Unexpected entry type");
        }
        ISignatureEntry signatureEntry = (ISignatureEntry)entry;
        Log.debug("Reviewing signature.");
        IVSSignatureEntry state = (IVSSignatureEntry)this.getSignatureReviewer().review((Object)signatureEntry, null, (IValidationParameters)new ValidationParameters());
        Log.debug("Signature review result: " + state.getState());
        StringBuilder sb = new StringBuilder();
        for (IValidationMessage message : state.getMessages()) {
            if (message.isInfo()) {
                sb.append("INFO: " + message.getText());
            } else if (message.isWarning()) {
                sb.append("WARNING: " + message.getText());
            } else if (message.isError()) {
                sb.append("ERROR: " + message.getText());
            }
            sb.append(StringTools.LS);
        }
        Log.debug(sb.toString());
        if (state.isInvalid()) {
            throw new SecurityApplicationException("Signature review failed:" + StringTools.LS + sb.toString());
        }
    }
}

