/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.intarsys.security.app.signature.SignatureItemEvidence;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SignatureEvidence
implements IStringEvaluator {
    private List<SignatureItemEvidence> items = new ArrayList<SignatureItemEvidence>();
    private final IStringEvaluator resolver = new ContainerResolver(){

        protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
            if ("items".equals(expression)) {
                return SignatureEvidence.this.getItems();
            }
            if ("itemLabels".equals(expression)) {
                return SignatureEvidence.this.getItems().stream().map(SignatureItemEvidence::getLabel).collect(Collectors.joining(", "));
            }
            if ("itemCount".equals(expression)) {
                return SignatureEvidence.this.getItemCount();
            }
            throw new EvaluationException("can't evaluate '" + expression + "'");
        }
    };

    public void addItem(SignatureItemEvidence item) {
        this.items.add(item);
    }

    public void finish() throws IOException {
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.resolver.evaluate(expression, args);
    }

    @JsonIgnore
    public int getItemCount() {
        return this.items.size();
    }

    public List<SignatureItemEvidence> getItems() {
        return new ArrayList<SignatureItemEvidence>(this.items);
    }

    public Map<String, Object> toMap() throws IOException {
        HashMap<String, Object> mapSad = new HashMap<String, Object>();
        ArrayList listItems = new ArrayList();
        for (SignatureItemEvidence itemEvidence : this.getItems()) {
            HashMap<String, String> mapItem = new HashMap<String, String>();
            mapItem.put("label", itemEvidence.getLabel());
            mapItem.put("hash", new String(Base64.encode((byte[])itemEvidence.getDigest().getEncoded())));
            listItems.add(mapItem);
        }
        mapSad.put("items", listItems);
        return mapSad;
    }
}

