/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.intarsys.security.app.signature.CommonSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.info.X500SimpleName;
import de.intarsys.tools.collection.MapTools;
import java.io.IOException;

public class SignerSerializer
extends StdSerializer<CommonSigner> {
    public SignerSerializer() {
        super(CommonSigner.class);
    }

    public void serialize(CommonSigner value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        IX509PublicKeyCertificate certificate = value.getCertificate();
        if (certificate != null) {
            X500SimpleName issuer = new X500SimpleName(certificate.getIssuerX500Principal());
            X500SimpleName subject = new X500SimpleName(certificate.getSubjectX500Principal());
            gen.writeObjectField("issuer", (Object)MapTools.builder().put((Object)"dn", (Object)issuer.getDistinguishedName()).build());
            gen.writeObjectField("subject", (Object)MapTools.builder().put((Object)"dn", (Object)subject.getDistinguishedName()).build());
        }
        gen.writeObjectField("signatureEvidence", (Object)value.getSignatureEvidence());
        gen.writeEndObject();
    }
}

