/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.manage.health.IHealthObject;
import de.intarsys.manage.health.IHealthSupport;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceFilter;
import de.intarsys.security.device.common.AbstractDeviceProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.health.CommonDeviceProviderHealth;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IEnablementSupport;
import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.PresentationMixin;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonDeviceProvider<T extends CommonDevice<?>>
extends AbstractDeviceProvider<T>
implements IPresentationSupport,
IFactory<T>,
IHealthSupport,
IEnablementSupport {
    private static final String ARG_PRIORITY = "priority";
    public static final String ARG_CONFIGURATION = "configuration";
    public static final String ARG_CONTEXT = "context";
    public static final String ARG_CLASSLOADER = "classLoader";
    private static final Logger Log = LoggerFactory.getLogger(CommonDeviceProvider.class);
    protected String ATTR_DEVICES = "devices";
    private final List<T> devices = new ArrayList<T>();
    private int priority = 0;
    private final PresentationMixin presentation = new PresentationMixin((Object)this);
    protected final Attribute attrDevice = new Attribute("device");
    private boolean allowSecretFromAPI = true;
    private boolean allowSecretFromCache = true;
    private boolean enabled = true;
    private LicenseProduct licenseProduct;
    private List<IApplicationDescriptor> applicationDescriptors;

    protected CommonDeviceProvider() {
        this.setId(this.getClass().getName());
    }

    protected CommonDeviceProvider(String id) {
        this.setId(id);
    }

    protected void basicClearDevices() {
        this.devices.clear();
    }

    protected T basicCreateInstance(IArgs args) throws ObjectCreationException {
        throw new ObjectCreationException("can't create new instances with factory " + this.getClass());
    }

    protected void basicCreateInstanceConfig(T object, IArgs args) throws ObjectCreationException {
        try {
            ((CommonDevice)object).setEnabled(this.isEnabled());
            if (this.isEnabled()) {
                ((CommonDevice)object).configure(args);
                ClassLoader classLoader = this.getClassLoader(args);
                IElement configuration = this.getConfiguration(args);
                if (configuration != null) {
                    if (object instanceof IElementConfigurable) {
                        object.configure(configuration);
                    }
                    ElementTools.setProperties(object, (IElement)configuration, (Object)classLoader);
                }
            }
            ((CommonDevice)object).init();
        }
        catch (Exception e) {
            ((CommonDevice)object).setException(e);
        }
    }

    protected void basicCreateInstanceInit(T object, IArgs args) throws ObjectCreationException {
        ClassLoader classLoader;
        Object context;
        if (object instanceof IInitializeable) {
            ((IInitializeable)object).initializeAfterCreation();
        }
        if ((context = this.getContext(args)) != null && object instanceof IContextSupport) {
            try {
                ((IContextSupport)object).setContext(context);
            }
            catch (ConfigurationException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if ((classLoader = this.getClassLoader(args)) != null && object instanceof IClassLoaderAccess) {
            ((IClassLoaderAccess)object).setClassLoader(classLoader);
        }
    }

    protected Iterator<T> basicListDevices(IDeviceFilter filter) {
        ArrayList<CommonDevice> tempDevices = new ArrayList<CommonDevice>();
        for (CommonDevice device : this.devices) {
            if (filter != null && !filter.accept(device)) continue;
            tempDevices.add(device);
        }
        return tempDevices.iterator();
    }

    protected IDevice basicLookupDevice(String pId) {
        for (CommonDevice device : this.devices) {
            if (!device.getId().equals(pId)) continue;
            return device;
        }
        return null;
    }

    protected T basicLookupInstance(IArgs args) throws ObjectCreationException {
        String id = this.getId(args);
        return (T)(id == null ? null : (CommonDevice)DeviceTools.lookupDevice(this, id));
    }

    protected void basicRegisterDevice(T device) {
        IDevice oldDevice = this.basicLookupDevice(((CommonDevice)device).getId());
        if (oldDevice != null) {
            this.devices.remove(oldDevice);
        }
        this.devices.add(device);
    }

    protected void basicUnregisterDevice(T device) {
        this.devices.remove(device);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setPriority(ElementTools.getInt((IElement)element, (String)ARG_PRIORITY, (int)this.getPriority()));
        IElement elDevices = element.element("devices");
        if (elDevices != null) {
            Iterator itDevices = elDevices.elementIterator();
            while (itDevices.hasNext()) {
                IElement elDevice = (IElement)itDevices.next();
                this.configureDevice(elDevice);
            }
        }
    }

    protected void configureDevice(IElement elDevice) throws ConfigurationException {
        throw new UnsupportedOperationException(this.getLabel() + " cannot configure devices");
    }

    protected CommonDeviceProviderHealth createHealth() {
        return new CommonDeviceProviderHealth();
    }

    protected void createHealthProperties(CommonDeviceProviderHealth health) {
        health.setEnabled(this.isEnabled());
        health.setId(this.getId());
        health.setType(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T createInstance(IArgs args) throws ObjectCreationException {
        T object;
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.basicLookupInstance(args);
            if (object == null && (object = this.basicCreateInstance(args)) != null) {
                this.basicCreateInstanceInit(object, args);
                this.basicCreateInstanceConfig(object, args);
                String id = ((CommonDevice)object).getId();
                if (id != null) {
                    this.registerDevice(object);
                }
            }
        }
        return object;
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
    }

    protected ILicenseAccount declareLicenseAccountDecrypt() {
        ILicenseAccount basicAccount = this.declareLicenseAccountDecryptBasic();
        if (basicAccount == null || basicAccount.isDefined()) {
            return basicAccount;
        }
        LicenseProduct productCommon = this.declareLicenseProductCommon();
        return productCommon.getAccount("de.intarsys.security.app.decrypt.account");
    }

    protected ILicenseAccount declareLicenseAccountDecryptBasic() {
        return null;
    }

    protected ILicenseAccount declareLicenseAccountSign() {
        ILicenseAccount basicAccount = this.declareLicenseAccountSignBasic();
        if (basicAccount == null || basicAccount.isDefined()) {
            return basicAccount;
        }
        LicenseProduct productCommon = this.declareLicenseProductCommon();
        return productCommon.getAccount("de.intarsys.security.app.sign.account");
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        return null;
    }

    protected void declareLicenseModel() {
        this.declareLicenseProductCommon();
        this.declareLicenseProduct();
    }

    protected LicenseProduct declareLicenseProduct() {
        return null;
    }

    protected LicenseProduct declareLicenseProductCommon() {
        LicenseProduct product = LicenseEnvironment.get().lookupProduct("de.intarsys.security.device.common");
        if (product == LicenseProduct.NA) {
            product = LicenseTools.createProduct(CommonDevice.class, (String)"de.intarsys.security.device.common");
            ILicenseAccount accountSign = product.getAccount("de.intarsys.security.app.sign.account");
            accountSign.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
            ILicenseAccount accountDecrypt = product.getAccount("de.intarsys.security.app.decrypt.account");
            accountDecrypt.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        }
        return product;
    }

    @Override
    public synchronized List<IApplicationDescriptor> getApplicationDescriptors() {
        return this.applicationDescriptors;
    }

    protected ClassLoader getClassLoader(IArgs args) {
        ClassLoader result = (ClassLoader)args.get(ARG_CLASSLOADER);
        return result == null ? this.getClass().getClassLoader() : result;
    }

    protected IElement getConfiguration(IArgs args) {
        Object result = args.get(ARG_CONFIGURATION);
        return result instanceof IElement ? (IElement)result : null;
    }

    protected Object getContext(IArgs args) {
        Object result = args.get(ARG_CONTEXT);
        return result;
    }

    public String getDescription() {
        return this.presentation.getDescription();
    }

    public IHealthObject getHealth() {
        CommonDeviceProviderHealth health = this.createHealth();
        this.createHealthProperties(health);
        return health;
    }

    public String getIconName() {
        return this.presentation.getIconName();
    }

    protected String getId(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"id", (String)"unique");
    }

    public String getLabel() {
        return this.presentation.getLabel();
    }

    protected synchronized LicenseProduct getLicenseProduct() {
        if (this.licenseProduct == null) {
            this.licenseProduct = this.declareLicenseProduct();
        }
        return this.licenseProduct;
    }

    protected String getLogPrefix() {
        return "device provider " + this.getId();
    }

    public int getPriority() {
        return this.priority;
    }

    public Class getResultType() {
        return CommonDevice.class;
    }

    public String getTip() {
        return this.presentation.getTip();
    }

    @Override
    public void init() {
        super.init();
        this.declareLicenseModel();
        this.applicationDescriptors = new ArrayList<IApplicationDescriptor>();
        this.declareApplicationDescriptors(this.applicationDescriptors);
        try {
            this.presentation.configure(this.getConfiguration());
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.setEnabled(ElementTools.getBool((IElement)this.getConfiguration(), (String)"enabled", (boolean)this.isEnabled()));
    }

    public boolean isAllowSecretFromAPI() {
        return this.allowSecretFromAPI;
    }

    public boolean isAllowSecretFromCache() {
        return this.allowSecretFromCache;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> listDevices(IDeviceFilter filter) {
        if (!this.isEnabled()) {
            Log.info("{} disabled, no devices listed", (Object)this.getLogPrefix());
            return Collections.emptyIterator();
        }
        Object object = this.lock;
        synchronized (object) {
            this.updateDevices();
            return this.basicListDevices(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDevice(T device) {
        Object object = this.lock;
        synchronized (object) {
            this.basicRegisterDevice(device);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)this.ATTR_DEVICES, null, device));
    }

    public void setAllowSecretFromAPI(boolean allowedSecretFromAPI) {
        this.allowSecretFromAPI = allowedSecretFromAPI;
    }

    public void setAllowSecretFromCache(boolean allowedSecretFromCache) {
        this.allowSecretFromCache = allowedSecretFromCache;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.presentation.setFormatArgs(new Object[]{this.getId()});
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDevice(T device) {
        Object object = this.lock;
        synchronized (object) {
            this.basicUnregisterDevice(device);
        }
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)this.ATTR_DEVICES, device, null));
    }

    protected void updateDevices() {
    }
}

