/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.device.common.CommonPrincipal;
import de.intarsys.security.standard.validation.QCTools;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.FieldNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CommonX509Principal
extends CommonPrincipal
implements IX509Principal {
    public static final String FIELD_CERTIFICATE = "certificate";
    public static final String FIELD_DERIVED_KEY_USAGE_ADVANCED_SIGNATURE = "derivedKeyUsageAdvancedSignature";
    public static final String FIELD_DERIVED_KEY_USAGE_QUALIFIED_SIGNATURE = "derivedKeyUsageQualifiedSignature";
    public static final String FIELD_DERIVED_KEY_USAGE_SIGNATURE = "derivedKeyUsageSignature";
    public static final String FIELD_ISSUER = "issuer";
    public static final String FIELD_KEY_OWNER = "keyOwner";
    public static final String FIELD_KEY_USAGE = "keyUsage";
    public static final String FIELD_KEY_USAGE_CRL_SIGN = "keyUsageCRLSign";
    public static final String FIELD_KEY_USAGE_DATA_ENCIPHERMENT = "keyUsageDataEncipherment";
    public static final String FIELD_KEY_USAGE_DECIPHER_ONLY = "keyUsageDecipherOnly";
    public static final String FIELD_KEY_USAGE_DIGITAL_SIGNATURE = "keyUsageDigitalSignature";
    public static final String FIELD_KEY_USAGE_ENCIPHER_ONLY = "keyUsageEncipherOnly";
    public static final String FIELD_KEY_USAGE_KEY_AGREEMENT = "keyUsageKeyAgreement";
    public static final String FIELD_KEY_USAGE_KEY_CERT_SIGN = "keyUsageKeyCertSign";
    public static final String FIELD_KEY_USAGE_KEY_ENCIPHERMENT = "keyUsageKeyEncipherment";
    public static final String FIELD_KEY_USAGE_NON_REPUDIATION = "keyUsageNonRepudiation";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_NOT_AFTER = "notAfter";
    public static final String FIELD_NOT_BEFORE = "notBefore";
    public static final String FIELD_SERIALNUMBER = "serialnumber";
    public static final String FIELD_SUBJECT = "subject";
    public static final String FIELD_VERSION = "version";
    private CommonX509Principal issuer;
    private IX509PublicKeyCertificate certificate;
    private boolean allowSecretFromCache;

    protected CommonX509Principal(IDevice device, IX509PublicKeyCertificate certificate, String id) {
        super(device, id);
        this.certificate = certificate;
    }

    protected IX509PublicKeyCertificate createCertificate() {
        return null;
    }

    protected CommonX509Principal createIssuer() {
        return null;
    }

    @Override
    public Map<String, String> getAttributeLabels() {
        return Stream.of(this.getX509PublicKeyCertificate().getX509Attributes()).collect(Collectors.toMap(IX509Attribute::getLabel, IX509Attribute::getStringValue));
    }

    @Override
    public String getCertificateUsageLabel() {
        return this.getX509PublicKeyCertificate().getCertificateUsage().getLabel();
    }

    @Override
    public byte[] getEncodedCertificate() throws CertificateEncodingException {
        return this.getX509PublicKeyCertificate().getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IX509Principal getIssuer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.issuer == null) {
                this.issuer = this.createIssuer();
            }
            return this.issuer;
        }
    }

    @Override
    public String getIssuerLabel() {
        return CertificateTools.getIssuerLabel((IX509Certificate)this.getX509PublicKeyCertificate());
    }

    @Override
    public X509Certificate getJavaCertificate() {
        try {
            return this.getX509PublicKeyCertificate().toJavaCertificate();
        }
        catch (CertificateException e) {
            return null;
        }
    }

    @Override
    public String getMonetaryLimit() {
        return CertificateTools.getMonetaryLimit((IX509Certificate)this.getX509PublicKeyCertificate());
    }

    @Override
    public String getSerialNumber() {
        return CertificateTools.getSerialNumber((IX509Certificate)this.getX509PublicKeyCertificate());
    }

    @Override
    public String getSubjectLabel() {
        return CertificateTools.getSubjectLabel((IX509Certificate)this.getX509PublicKeyCertificate());
    }

    public boolean[] getX509KeyUsage() {
        return this.getX509PublicKeyCertificate().getCertificateUsage().getX509KeyUsage();
    }

    @Override
    public Object getValue(String name) throws FieldException {
        if (name == null) {
            throw new FieldNotFoundException("name is null");
        }
        Object value = super.getValue(name);
        if (value != null) {
            return value;
        }
        if (FIELD_KEY_OWNER.equals(name)) {
            return this.isKeyOwner();
        }
        IX509PublicKeyCertificate publicKeyCertificate = this.getX509PublicKeyCertificate();
        if (publicKeyCertificate == null) {
            return null;
        }
        return switch (name) {
            case FIELD_DERIVED_KEY_USAGE_SIGNATURE -> Boolean.valueOf(publicKeyCertificate.getCertificateUsage().isSignature());
            case FIELD_DERIVED_KEY_USAGE_QUALIFIED_SIGNATURE -> Boolean.valueOf(publicKeyCertificate.getCertificateUsage().isSignatureWithNonRepudiation());
            case FIELD_DERIVED_KEY_USAGE_ADVANCED_SIGNATURE -> Boolean.valueOf(publicKeyCertificate.getCertificateUsage().isSignatureWithoutNonRepudiation());
            case FIELD_KEY_USAGE_DIGITAL_SIGNATURE -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[0]);
            case FIELD_KEY_USAGE_NON_REPUDIATION -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[1]);
            case FIELD_KEY_USAGE_KEY_ENCIPHERMENT -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[2]);
            case FIELD_KEY_USAGE_DATA_ENCIPHERMENT -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[3]);
            case FIELD_KEY_USAGE_KEY_AGREEMENT -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[4]);
            case FIELD_KEY_USAGE_KEY_CERT_SIGN -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[5]);
            case FIELD_KEY_USAGE_CRL_SIGN -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[6]);
            case FIELD_KEY_USAGE_ENCIPHER_ONLY -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[7]);
            case FIELD_KEY_USAGE_DECIPHER_ONLY -> Boolean.valueOf(publicKeyCertificate.getKeyUsage()[8]);
            case FIELD_CERTIFICATE -> publicKeyCertificate;
            case FIELD_VERSION -> Integer.valueOf(publicKeyCertificate.getVersion());
            case FIELD_SERIALNUMBER -> publicKeyCertificate.getSerialNumber();
            case FIELD_LABEL -> CertificateTools.getSubjectLabel((IX509Certificate)publicKeyCertificate);
            case FIELD_ISSUER -> publicKeyCertificate.getIssuerX500Principal().toString();
            case FIELD_SUBJECT -> publicKeyCertificate.getSubjectX500Principal().toString();
            case FIELD_NOT_BEFORE -> publicKeyCertificate.getNotBefore();
            case FIELD_NOT_AFTER -> publicKeyCertificate.getNotAfter();
            case FIELD_KEY_USAGE -> (Object)publicKeyCertificate.getKeyUsage();
            default -> throw new FieldNotFoundException(this.getClass(), name);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IX509PublicKeyCertificate getX509PublicKeyCertificate() {
        Object object = this.lock;
        synchronized (object) {
            if (this.certificate == null) {
                this.certificate = this.createCertificate();
            }
            return this.certificate;
        }
    }

    @Override
    public boolean isKeyOwner() {
        return false;
    }

    @Override
    public boolean isKeyUsage(String id) {
        Integer index = (Integer)CertificateUsage.KEYUSAGE_INDICES.get(id.trim());
        if (index == null) {
            return false;
        }
        return this.getX509KeyUsage()[index];
    }

    @Override
    public boolean isQualified() {
        try {
            return QCTools.isQualificationPostulated((IX509Certificate)this.getX509PublicKeyCertificate());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isSecretCachable() {
        return this.allowSecretFromCache;
    }

    public void setAllowSecretFromCache(boolean secretCachable) {
        this.allowSecretFromCache = secretCachable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIssuer(CommonX509Principal issuer) {
        Object object = this.lock;
        synchronized (object) {
            this.issuer = issuer;
        }
    }
}

