/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceFilter;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.reflect.IWrapper;
import de.intarsys.tools.reflect.InvocableMethod;
import java.util.Iterator;
import java.util.List;

public abstract class DelegatingDeviceProvider<DD extends IDevice, DO extends IDevice>
implements IDeviceProvider<DO>,
IWrapper<IDeviceProvider> {
    private final IDeviceProvider<DD> delegate;

    public DelegatingDeviceProvider(IDeviceProvider<DD> delegate) {
        this.delegate = delegate;
    }

    public void addNotice(INotice notice) {
        this.delegate.addNotice(notice);
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.delegate.addNotificationListener(type, listener);
    }

    protected Iterator<DD> basicListDevices(IDeviceFilter filter) {
        return this.delegate.listDevices(filter);
    }

    public void clearNotices() {
        this.delegate.clearNotices();
    }

    @Override
    public List<IApplicationDescriptor> getApplicationDescriptors() {
        return this.delegate.getApplicationDescriptors();
    }

    public Object getAttribute(Object key) {
        return this.delegate.getAttribute(key);
    }

    public IDeviceProvider<DD> getDelegate() {
        return this.delegate;
    }

    @Override
    @InvocableMethod
    public String getId() {
        return this.delegate.getId();
    }

    public List<INotice> getNotices() {
        return this.delegate.getNotices();
    }

    public IDeviceProvider getWrapped() {
        return this.delegate;
    }

    protected boolean hookAcceptDevice(DD device) {
        return true;
    }

    protected DO hookConvertDevice(DD sourceDevice) {
        return (DO)sourceDevice;
    }

    @Override
    public Iterator<DO> listDevices(IDeviceFilter filter) {
        Iterator<DD> devices = this.basicListDevices(filter);
        FilterIterator filteredDevices = new FilterIterator<DD>(devices){

            protected boolean accept(DD device) {
                return DelegatingDeviceProvider.this.hookAcceptDevice(device);
            }
        };
        return new ConversionIterator<DD, DO>((Iterator)filteredDevices){

            protected DO createTargetObject(DD sourceObject) {
                return DelegatingDeviceProvider.this.hookConvertDevice(sourceObject);
            }
        };
    }

    public Object removeAttribute(Object key) {
        return this.delegate.removeAttribute(key);
    }

    public boolean removeNotice(INotice notice) {
        return this.delegate.removeNotice(notice);
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.delegate.removeNotificationListener(type, listener);
    }

    public Object setAttribute(Object key, Object value) {
        return this.delegate.setAttribute(key, value);
    }
}

