/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.common.DelegatingCredential;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.notice.INotice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FirewallCredential
extends DelegatingCredential {
    private final EventDispatcher eventDispatcher = new EventDispatcher((Object)this);
    private final List<INotice> notices = new CopyOnWriteArrayList<INotice>();
    private final AttributeMap attributes = new AttributeMap();
    private final INotificationListener<Event> listener = arg_0 -> ((EventDispatcher)this.eventDispatcher).triggerEvent(arg_0);

    public FirewallCredential(IDevice device, ICredential delegate) {
        super(device, delegate);
        delegate.addNotificationListener(EventType.ALWAYS, this.listener);
    }

    @Override
    public void addNotice(INotice notice) {
        this.notices.add(notice);
        this.eventDispatcher.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", null, (Object)notice));
    }

    @Override
    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    @Override
    public void clearNotices() {
        this.notices.clear();
        super.clearNotices();
    }

    public void dispose() {
        this.getDelegate().removeNotificationListener(EventType.ALWAYS, this.listener);
        this.attributes.clear();
        this.notices.clear();
        this.eventDispatcher.clear();
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public List<INotice> getNotices() {
        ArrayList<INotice> list = new ArrayList<INotice>();
        list.addAll(super.getNotices());
        list.addAll(this.notices);
        return Collections.unmodifiableList(list);
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    @Override
    public boolean removeNotice(INotice notice) {
        if (this.notices.remove(notice)) {
            this.eventDispatcher.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", (Object)notice, null));
            return true;
        }
        return super.removeNotice(notice);
    }

    @Override
    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }
}

