/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.conversationsigner;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.jca.conversationsigner.ConversationSignerKeystoreSpi;
import de.intarsys.security.jca.conversationsigner.ConversationSignerProvider;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.ToBeSignedData;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ConversationSignerSignatureSpi
extends SignatureSpi {
    private IDigester digester;
    private final ConversationSignerProvider provider;

    public ConversationSignerSignatureSpi(ConversationSignerProvider provider, IDigester digester) {
        this.provider = provider;
        this.digester = digester;
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        if (!(privateKey instanceof ConversationSignerKeystoreSpi.PrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.provider.handleInitSign(privateKey);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            IDigest digest = this.digester.digestFinal();
            ToBeSignedData data = ToBeSignedData.create((IDigest)digest);
            try {
                Future<ISignatureData> signature = this.provider.handleSign((IToBeSignedData)data);
                return signature.get().getEncodedSignature();
            }
            catch (ExecutionException e) {
                throw (SecurityApplicationException)ExceptionTools.unwrapTyped((Throwable)e, SecurityApplicationException.class);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SignatureException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            throw new SignatureException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        try {
            this.digester.digestUpdate((InputStream)new ByteArrayInputStream(new byte[]{b}));
        }
        catch (IOException e) {
            throw new IllegalStateException("byte array input stream failed");
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        try {
            this.digester.digestUpdate((InputStream)new ByteArrayInputStream(b, off, len));
        }
        catch (IOException e) {
            throw new IllegalStateException("byte array input stream failed");
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        return false;
    }
}

