/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.device.IDevice;
import de.intarsys.security.jca.device.DeviceKeyStoreSpi;
import de.intarsys.security.jca.device.DeviceSignatureSpiRSAPKCS1;
import de.intarsys.security.jca.device.DeviceSignatureSpiRSAPSS;
import java.security.Provider;
import java.util.Collections;

public class DeviceBasedProvider
extends Provider {
    public DeviceBasedProvider() {
        this((IDevice)null);
    }

    public DeviceBasedProvider(final IDevice device) {
        super("Device", "1.1", "IDevice based JCA provider");
        if (device != null) {
            this.putService(new Provider.Service(this, "KeyStore", "Device", DeviceKeyStoreSpi.class.getName(), Collections.emptyList(), null){

                @Override
                public Object newInstance(Object constructorParameter) {
                    return new DeviceKeyStoreSpi(device);
                }
            });
        }
        this.put("Signature.RSA", DeviceSignatureSpiRSAPKCS1.None.class.getName());
        this.addPKCS1Signature("SHA1", DeviceSignatureSpiRSAPKCS1.SHA1.class.getName());
        this.addPKCS1Signature("SHA256", DeviceSignatureSpiRSAPKCS1.SHA256.class.getName());
        this.addPKCS1Signature("SHA512", DeviceSignatureSpiRSAPKCS1.SHA512.class.getName());
        this.put("Signature.RAWRSASSA-PSS", DeviceSignatureSpiRSAPSS.None.class.getName());
        this.put("Signature.RSASSA-PSS", DeviceSignatureSpiRSAPSS.Default.class.getName());
        this.addPSSSignature("SHA1", "MGF1", DeviceSignatureSpiRSAPSS.SHA1.class.getName());
        this.addPSSSignature("SHA256", "MGF1", DeviceSignatureSpiRSAPSS.SHA256.class.getName());
        this.addPSSSignature("SHA512", "MGF1", DeviceSignatureSpiRSAPSS.SHA512.class.getName());
    }

    private void addPKCS1Signature(String digest, String className) {
        String mainName = digest + "WITHRSA";
        this.put("Signature." + mainName, className);
        this.put("Alg.Alias.Signature." + digest + "withRSA", mainName);
        this.put("Alg.Alias.Signature." + digest + "WithRSA", mainName);
    }

    private void addPSSSignature(String digest, String mgf, String className) {
        String stem = "WITHRSAAND" + mgf;
        String mainName = digest + stem;
        this.put("Signature." + mainName, className);
        this.put("Alg.Alias.Signature." + digest + "withRSAand" + mgf, mainName);
        this.put("Alg.Alias.Signature." + digest + "WithRSAAnd" + mgf, mainName);
        if (mgf.equals("MGF1")) {
            this.put("Alg.Alias.Signature." + digest + "withRSA/PSS", mainName);
            this.put("Alg.Alias.Signature." + digest + "WithRSA/PSS", mainName);
            this.put("Alg.Alias.Signature." + digest + "withRSASSA-PSS", mainName);
            this.put("Alg.Alias.Signature." + digest + "WithRSASSA-PSS", mainName);
            this.put("Alg.Alias.Signature." + digest + "WITHRSASSA-PSS", mainName);
        }
    }
}

