/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.jca.device.DeviceSignerECPrivateKey;
import de.intarsys.security.jca.device.DeviceSignerRSAPrivateKey;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;

public abstract class DeviceSignerPrivateKey
implements PrivateKey {
    private IDevice signerDevice;
    private IArgs signerArgs;
    private IX509Principal signerPrincipal;

    public static DeviceSignerPrivateKey create(IDevice signerDevice, IArgs signerArgs, IX509Principal signerPrincipal) {
        IX509PublicKeyCertificate signerCertificate = signerPrincipal.getX509PublicKeyCertificate();
        if (signerCertificate == null) {
            return null;
        }
        if (signerCertificate.getPublicKey() instanceof RSAKey) {
            return new DeviceSignerRSAPrivateKey(signerDevice, signerArgs, signerPrincipal);
        }
        if (signerCertificate.getPublicKey() instanceof ECKey) {
            return new DeviceSignerECPrivateKey(signerDevice, signerArgs, signerPrincipal);
        }
        return null;
    }

    protected DeviceSignerPrivateKey(IDevice signerDevice, IArgs signerArgs, IX509Principal signerPrincipal) {
        this.signerDevice = signerDevice;
        this.signerArgs = signerArgs;
        this.signerPrincipal = signerPrincipal;
    }

    public ISigner createSigner(IArgs args) {
        IArgs allArgs = this.getSignerArgs().copy();
        ArgTools.putPath((IArgs)allArgs, (String)"signerIdentifier", (Object)this.getSignerPrincipal().getX509PublicKeyCertificate());
        ArgTools.putAll((IArgs)allArgs, (IArgs)args);
        try {
            return (ISigner)this.getSignerDevice().createApplication(ISigner.class.getName(), allArgs);
        }
        catch (ObjectCreationException e) {
            throw new IllegalStateException("Cannot create signer app: " + e.getMessage(), e);
        }
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    protected IArgs getSignerArgs() {
        return this.signerArgs;
    }

    protected IDevice getSignerDevice() {
        return this.signerDevice;
    }

    protected IX509Principal getSignerPrincipal() {
        return this.signerPrincipal;
    }

    protected PublicKey getSignerPublicKey() {
        IX509PublicKeyCertificate certificate = this.getSignerPrincipal().getX509PublicKeyCertificate();
        if (certificate == null) {
            return null;
        }
        return certificate.getPublicKey();
    }
}

