/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.validation;

import de.intarsys.cloudsuite.gears.validation.task.TrustedListUpdateTask;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.common.LocalCRLProvider;
import de.intarsys.security.crl.common.OnlineCRLProvider;
import de.intarsys.security.crlstore.ManagedCRLProvider;
import de.intarsys.security.validation.ValidationEnvironment;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GearsValidationConfig {
    @Value(value="${crls.persist:true}")
    private boolean persistCrls;

    @Bean
    public ICRLProvider crlProvider() {
        ManagedCRLProvider crlProvider;
        if (this.isPersistCrls()) {
            crlProvider = new ManagedCRLProvider();
        } else {
            LocalCRLProvider localCrlProvider = new LocalCRLProvider();
            localCrlProvider.addDelegateProvider((ICRLProvider)new OnlineCRLProvider());
            crlProvider = localCrlProvider;
        }
        ValidationEnvironment.get().setCRLProvider((ICRLProvider)crlProvider);
        return crlProvider;
    }

    public boolean isPersistCrls() {
        return this.persistCrls;
    }

    public void setPersistCrls(boolean persistCrls) {
        this.persistCrls = persistCrls;
    }

    @Bean
    @ConditionalOnProperty(name={"trustedLists.update.cron"})
    public TrustedListUpdateTask trustedListUpdateTask() {
        return new TrustedListUpdateTask();
    }
}

