/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.smartcard;

import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.device.pool.device.PoolDeviceFactoryBean;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.security.device.pool.smartcard.PACKAGE;
import de.intarsys.security.device.pool.smartcard.SmartcardPoolListener;
import de.intarsys.security.smartcard.card.CardFilterTools;
import de.intarsys.security.smartcard.card.CardTerminalFilterTools;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.ConverterException;

public class SmartcardPoolDeviceFactoryBean
extends PoolDeviceFactoryBean {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String disableSPE;
    private Secret pin;
    private IPasswordProvider passwordProvider;
    private Object cardFilter;
    private Object certificateFilter;
    private Object cardTerminalFilter;

    public SmartcardPoolDeviceFactoryBean() {
        this.setTypeDescription(Msg.getString("SmartcardPoolDeviceFactoryBean.typeDescription", new Object[0]));
    }

    protected IPoolListener createPoolListener(GenericPool pool) throws ObjectCreationException {
        SmartcardPoolListener poolListener = new SmartcardPoolListener(pool);
        try {
            poolListener.setDisableSPE(Converter.asThreeState((String)this.getDisableSPE()));
        }
        catch (ConverterException e) {
            throw new ObjectCreationException((Throwable)e);
        }
        poolListener.setCardFilter(CardFilterTools.createCardFilter((Object)this.getCardFilter()));
        poolListener.setCertificateFilter(CertificateFilterTools.createCertificateFilter((Object)this.getCertificateFilter()));
        poolListener.setCardTerminalFilter(CardTerminalFilterTools.createCardTerminalFilter((Object)this.getCardTerminalFilter()));
        poolListener.setPin(this.getPin());
        poolListener.setPasswordProvider(this.getPasswordProvider());
        return poolListener;
    }

    public Object getCardFilter() {
        return this.cardFilter;
    }

    public Object getCardTerminalFilter() {
        return this.cardTerminalFilter;
    }

    public Object getCertificateFilter() {
        return this.certificateFilter;
    }

    public String getDisableSPE() {
        return this.disableSPE;
    }

    public IPasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public Secret getPin() {
        return this.pin;
    }

    public void setCardFilter(Object cardFilter) {
        this.cardFilter = cardFilter;
    }

    public void setCardTerminalFilter(Object cardTerminalFilter) {
        this.cardTerminalFilter = cardTerminalFilter;
    }

    public void setCertificateFilter(Object certificateFilter) {
        this.certificateFilter = certificateFilter;
    }

    public void setDisableSPE(String disableSPE) {
        this.disableSPE = disableSPE;
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public void setPin(Secret pin) {
        this.pin = pin;
    }
}

