/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.smartcard;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.pool.impl.AcceptException;
import de.intarsys.security.device.pool.impl.CommonPoolListener;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.security.device.pool.smartcard.ISmartcardPoolMonitorListener;
import de.intarsys.security.device.pool.smartcard.PACKAGE;
import de.intarsys.security.device.pool.smartcard.SmartcardPoolMonitor;
import de.intarsys.security.device.smartcard.app.signature.SmartcardSigner;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDeviceProvider;
import de.intarsys.security.smartcard.app.common.IExtractCertificateApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardFilter;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.ICardTerminalFilter;
import de.intarsys.security.smartcard.environment.SmartcardEnvironment;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IFactorySupport;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.IElementSerializationHandler;
import de.intarsys.tools.lang.BooleanTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.Converter;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartcardPoolListener<T extends ISecurityApplication>
extends CommonPoolListener<T>
implements ISmartcardPoolMonitorListener {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(SmartcardPoolListener.class);
    private static final SmartcardPoolMonitor MONITOR = new SmartcardPoolMonitor();
    private ICardFilter cardFilter;
    private ICardTerminalFilter cardTerminalFilter;
    private Boolean disableSPE = null;

    public SmartcardPoolListener(GenericPool<T> pool) {
        super(pool);
    }

    public void authenticate(GenericPool<T> pool, PoolEntry<T> entry) throws AcceptException, SecurityApplicationException {
        SmartcardSigner signer = (SmartcardSigner)entry.getSecurityApplication();
        if (this.getPasswordProvider() != null) {
            signer.setPasswordProvider(this.getPasswordProvider());
        }
        if (!CryptoTools.isEmpty((Secret)this.getPin())) {
            signer.setAuthenticationPin(this.getPin());
        }
        ICard card = signer.getCardApplication().getCard();
        ICardTerminal cardTerminal = card.getCardTerminal();
        ICardHolderCertificate cert = signer.getCertificate();
        String subjectName = CertificateTools.getSubjectLabel((IX509Certificate)cert);
        String certificateLabel = Msg.getString("SmartcardPoolListener.certificateLabel", new Object[]{pool.getLabel(), cardTerminal.getName(), subjectName, cert.getCertificateUsage().getLabel()});
        String pinLabel = signer.getCardApplication().getAuthenticationPinInfo().getLabel();
        String tmpPrompt = Msg.getString("SmartcardPoolListener.authenticationPrompt", new Object[]{certificateLabel, pinLabel});
        signer.setAuthenticationPrompt(tmpPrompt);
        try {
            signer.authenticate().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SecurityApplicationException("execution interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw (SecurityApplicationException)ExceptionTools.createTypedFromChain((Throwable)e, SecurityApplicationException.class);
        }
    }

    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        String valueString = element.attributeValue("disableSPE", null);
        Boolean valueBoolean = Converter.asThreeState((String)valueString, (Boolean)this.getDisableSPE());
        this.setDisableSPE(valueBoolean);
        try {
            IElement cardTerminalFilterElement = element.element("cardTerminalFilter");
            if (cardTerminalFilterElement != null) {
                this.setCardTerminalFilter((ICardTerminalFilter)ElementTools.createObject((IElement)cardTerminalFilterElement, ICardTerminalFilter.class, (Object)this.getContext(), (IArgs)Args.create()));
            }
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected String createErrorMessageWithCerts(String msg, Collection<ICardHolderCertificate> certificates) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append("\navailable certificates:\n\n");
        for (ICardHolderCertificate cert : certificates) {
            sb.append(cert.toString());
            sb.append("\n\n");
        }
        return sb.toString();
    }

    protected Class<ISigner> getApplicationType() {
        return ISigner.class;
    }

    protected Class<ISignApplication> getCardApplicationType() {
        return ISignApplication.class;
    }

    public ICardFilter getCardFilter() {
        return this.cardFilter;
    }

    public ICardTerminalFilter getCardTerminalFilter() {
        return this.cardTerminalFilter;
    }

    public Boolean getDisableSPE() {
        return this.disableSPE;
    }

    @Override
    public void housekeeping() {
    }

    public boolean isDisableSPE() {
        return this.disableSPE == null ? false : this.disableSPE;
    }

    public void onStartAfter(GenericPool<T> pool) {
        MONITOR.registerListener(this);
    }

    public void onStartBefore(GenericPool<T> pool) {
    }

    public void onStopAfter(GenericPool<T> pool) {
    }

    public void onStopBefore(GenericPool<T> pool) {
        MONITOR.unregisterListener(this);
    }

    @Override
    public void openApplication(ICardConnection connection) throws AcceptException {
        if (!this.getPool().isStarted()) {
            String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptNotStarted", new Object[]{this.getPool().getLabel()});
            throw new AcceptException(msg);
        }
        if (this.getCardTerminalFilter() != null && !this.getCardTerminalFilter().accept(connection.getCardTerminal())) {
            String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptCardTerminalFilterNoMatch", new Object[]{this.getPool().getLabel(), this.getCardTerminalFilter()});
            throw new AcceptException(msg);
        }
        if (this.getCardFilter() != null && !this.getCardFilter().accept(connection.getCard())) {
            String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptCardFilterNoMatch", new Object[]{this.getPool().getLabel(), this.getCardFilter()});
            throw new AcceptException(msg);
        }
        Class<ISignApplication> cardAppType = this.getCardApplicationType();
        try {
            Log.debug("{} open card application on {}", this.getLogLabel(), (Object)connection);
            ICardProduct product = CardProductTools.getCardProduct((ICardConnection)connection);
            ICardHolderApplication cardApp = (ICardHolderApplication)product.createCardApplication(connection, cardAppType);
            Log.debug("{} opened card application on {}", this.getLogLabel(), (Object)connection);
            cardApp.setEnforceSPE(SmartcardEnvironment.get().isEnforceSPE() && !this.isDisableSPE());
            cardApp.setDisableSPE(SmartcardEnvironment.get().isDisableSPE() || this.isDisableSPE());
            ISignApplication signApplication = (ISignApplication)cardApp;
            ICardHolderCertificate certificate = this.searchCertificate((ICardApplication)signApplication);
            signApplication.setCardHolderCertificate(certificate);
            SmartcardDeviceProvider provider = (SmartcardDeviceProvider)((Object)DeviceTools.lookupDeviceProvider(SmartcardDeviceProvider.class));
            SmartcardDevice device = provider.createInstance(cardApp.getCard().getCardTerminal());
            Args args = Args.create();
            args.put("cardApplication", (Object)signApplication);
            ISecurityApplication app = (ISecurityApplication)device.createApplication(this.getApplicationType().getName(), (IArgs)args);
            ICard card = cardApp.getCard();
            ICardTerminal cardTerminal = card.getCardTerminal();
            String subjectName = CertificateTools.getSubjectLabel((IX509Certificate)certificate);
            String label = Msg.getString("SmartcardPoolListener.certificateLabel", new Object[]{this.getPool().getLabel(), cardTerminal.getName(), subjectName, certificate.getCertificateUsage().getLabel()});
            IExtractCertificateApplication extractApp = (IExtractCertificateApplication)product.createCardApplication(connection, IExtractCertificateApplication.class);
            extractApp.getPublicKeyCertificates();
            this.getPool().addApplication(app, label);
        }
        catch (AcceptException e) {
            throw e;
        }
        catch (Exception e) {
            Log.info("{} can't open application ({})", this.getLogLabel(), (Object)ExceptionTools.getMessageShort((Throwable)e));
            String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptCantOpenApplication", new Object[]{this.getPool().getLabel(), ExceptionTools.getMessageShort((Throwable)e)});
            throw new AcceptException(msg, (Throwable)e);
        }
    }

    public void preferencesRestore(IPreferences prefs) {
        super.preferencesRestore(prefs);
        try {
            String tmpString = prefs.get("certificateFilter");
            IX509CertificateFilter tempFilter = CertificateFilterTools.createCertificateFilter((Object)tmpString);
            if (tempFilter != null) {
                this.setCertificateFilter(tempFilter);
            }
        }
        catch (ObjectCreationException e) {
            Log.warn("{} failed to restore preferences ", (Object)this, (Object)e);
        }
    }

    public void preferencesStore(IPreferences prefs) {
        super.preferencesStore(prefs);
        try {
            if (this.getCertificateFilter() instanceof IElementSerializable) {
                IElement element = ElementFactory.get().createElement("certificateFilter");
                ((IElementSerializable)this.getCertificateFilter()).serialize(element);
                prefs.put("certificateFilter", element.asXML());
            }
        }
        catch (ElementSerializationException e) {
            Log.warn("{} failed to store preferences ", (Object)this, (Object)e);
        }
    }

    public void refresh() {
        MONITOR.refresh();
    }

    public void retry(GenericPool<T> genericPool, PoolEntry<T> entry) {
        SmartcardSigner signer = (SmartcardSigner)entry.getSecurityApplication();
        signer.dispose();
        ICard card = signer.getCardApplication().getCard();
        MONITOR.connectLater(card);
    }

    protected ICardHolderCertificate searchCertificate(ICardApplication app) throws AcceptException {
        IX509CertificateFilter selector = this.getCertificateFilter();
        if (!(app instanceof ICardHolderApplication)) {
            String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptNoCertificates", new Object[]{this.getPool().getLabel()});
            throw new AcceptException(msg);
        }
        Collection certificates = ((ICardHolderApplication)app).getSupportedCardHolderCertificates();
        if (selector == null) {
            if (certificates.size() > 1) {
                String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptNoCertificateSelector", new Object[]{this.getPool().getLabel()});
                String msgWithCerts = this.createErrorMessageWithCerts(msg, certificates);
                throw new AcceptException(msgWithCerts);
            }
            return (ICardHolderCertificate)certificates.iterator().next();
        }
        ICardHolderCertificate result = null;
        for (ICardHolderCertificate cert : certificates) {
            if (!selector.accept((IX509Certificate)cert)) continue;
            if (result != null) {
                String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptCertificateSelectorNotUnique", new Object[]{this.getPool().getLabel(), this.getCertificateFilter()});
                String msgWithCerts = this.createErrorMessageWithCerts(msg, certificates);
                throw new AcceptException(msgWithCerts);
            }
            result = cert;
        }
        if (result == null) {
            String msg = Msg.getString("SmartcardPoolListener.ErrorAcceptDoesNotMatch", new Object[]{this.getPool().getLabel()});
            String msgWithCerts = this.createErrorMessageWithCerts(msg, certificates);
            throw new AcceptException(msgWithCerts);
        }
        return result;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setAttributeValue("disableSPE", BooleanTools.toStringThreeState((Boolean)this.getDisableSPE()));
        ICardTerminalFilter target = this.getCardTerminalFilter();
        if (target != null) {
            IFactory factory;
            IElement tempElement = element.newElementMapped("cardTerminalFilter");
            if (target instanceof IElementSerializable) {
                ((IElementSerializable)target).serialize(tempElement);
            } else if (target instanceof IFactorySupport && (factory = ((IFactorySupport)target).getFactory()) instanceof IElementSerializationHandler) {
                ((IElementSerializationHandler)factory).serialize((Object)target, tempElement);
            }
        }
    }

    public void setCardFilter(ICardFilter cardFilter) {
        this.cardFilter = cardFilter;
    }

    public void setCardTerminalFilter(ICardTerminalFilter cardTerminalFilter) {
        this.cardTerminalFilter = cardTerminalFilter;
    }

    public void setDisableSPE(Boolean disableSPE) {
        this.disableSPE = disableSPE;
    }
}

