/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.smartcard;

import de.intarsys.security.device.pool.impl.AcceptException;
import de.intarsys.security.device.pool.smartcard.ISmartcardPoolMonitorListener;
import de.intarsys.security.device.pool.smartcard.PACKAGE;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardSystem;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.CommonCardConnectionMonitor;
import de.intarsys.security.smartcard.card.EnumCardState;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.PresentationAdapter;
import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import de.intarsys.tools.reporter.ReplayReporter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartcardPoolMonitor
extends CommonCardConnectionMonitor
implements IReporterSupport {
    private static final Logger Log = LoggerFactory.getLogger(SmartcardPoolMonitor.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final List<ISmartcardPoolMonitorListener> listeners = new ArrayList<ISmartcardPoolMonitorListener>();
    private final ReplayReporter reporter = new ReplayReporter((Object)this);
    private int reportingFlags = 3;

    protected SmartcardPoolMonitor() {
        super(CardSystem.get());
    }

    protected void accept(ICardConnection connection) {
        ArrayList<ISmartcardPoolMonitorListener> tempListeners = this.getListeners();
        ArrayList<AcceptException> exceptions = new ArrayList<AcceptException>();
        for (ISmartcardPoolMonitorListener policy : tempListeners) {
            try {
                policy.openApplication(connection);
                IPresentationSupport ps = PresentationAdapter.create((Object)policy);
                String label = ps.getLabel();
                this.getReporter().reportStatus(Msg.getString("SmartcardPoolMonitor.reportPoolAcceptedCard", new Object[]{label}), 0);
                Log.info("{} {} accepted by {}", new Object[]{this.getLogPrefix(), connection, policy});
                return;
            }
            catch (AcceptException e) {
                exceptions.add(e);
                boolean retry = CardTools.isRetry((ICard)connection.getCard(), (Throwable)e.getCause(), (int)0);
                if (!retry) continue;
                Log.info("{} accept {} failed ({}), retry", new Object[]{this.getLogPrefix(), connection, ExceptionTools.getMessage((Throwable)e)});
                this.connectLater(connection.getCard());
                break;
            }
        }
        try {
            connection.close(0);
        }
        catch (CardException cardException) {
            // empty catch block
        }
        if (exceptions.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Msg.getString("SmartcardPoolMonitor.ErrorNoPoolAvailableToAccept", new Object[]{connection.getCardTerminal().getName()}));
            sb.append("\n");
            for (AcceptException ex : exceptions) {
                sb.append("\n");
                sb.append(ex.getMessage());
            }
            Log.warn("{} {}", this.getLogPrefix(), (Object)sb.toString());
            this.getReporter().reportMessage(Msg.getString("SmartcardPoolMonitor.report.title", new Object[0]), sb.toString(), this.reportingFlags);
        }
    }

    public void addReporter(IReporter pReporter) {
        this.reporter.addReporter(pReporter);
    }

    protected void cleanup() {
        ArrayList<ISmartcardPoolMonitorListener> tempListeners = this.getListeners();
        for (ISmartcardPoolMonitorListener listener : tempListeners) {
            listener.housekeeping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<ISmartcardPoolMonitorListener> getListeners() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<ISmartcardPoolMonitorListener>(this.listeners);
        }
    }

    protected Object getLogPrefix() {
        return this.toString();
    }

    public IReporter getReporter() {
        return this.reporter;
    }

    protected int getReportingFlags() {
        return this.reportingFlags;
    }

    protected void onCardInserted(ICard card) {
        super.onCardInserted(card);
        this.getReporter().reportStatus(Msg.getString("SmartcardPoolMonitor.reportCardInserted", new Object[]{card}), 0);
        this.connect(card);
    }

    protected void onCardRemoved(ICard card) {
        super.onCardRemoved(card);
        this.getReporter().reportStatus(Msg.getString("SmartcardPoolMonitor.reportCardRemoved", new Object[]{card}), 0);
        this.cleanup();
    }

    protected void onCardTerminalConnected(ICardTerminal terminal) {
        super.onCardTerminalConnected(terminal);
        this.getReporter().reportStatus(Msg.getString("SmartcardPoolMonitor.reportCardTerminalAdded", new Object[]{terminal}), 0);
    }

    protected void onCardTerminalDisconnected(ICardTerminal terminal) {
        super.onCardTerminalDisconnected(terminal);
        this.cleanup();
        this.getReporter().reportStatus(Msg.getString("SmartcardPoolMonitor.reportCardTerminalRemoved", new Object[]{terminal}), 0);
    }

    protected void onConnected(ICardConnection connection) {
        this.accept(connection);
    }

    protected void onConnectionFailed(ICard card, TaskFailed cardException) {
        super.onConnectionFailed(card, cardException);
        String msg = Msg.getString("SmartcardPoolMonitor.cardNotSupported", new Object[]{card.getCardTerminal().getName()});
        Log.warn("{} {}", this.getLogPrefix(), (Object)msg);
        this.getReporter().reportMessage(Msg.getString("SmartcardPoolMonitor.report.title", new Object[0]), msg, this.reportingFlags);
    }

    public void refresh() {
        if (!this.isStarted()) {
            return;
        }
        this.getEventExecutor().submit(new Runnable(){

            @Override
            public void run() {
                for (ICardTerminal terminal : SmartcardPoolMonitor.this.getCardSystem().getCardTerminals()) {
                    EnumCardState tempState;
                    ICard card = terminal.getCard();
                    if (card == null || (tempState = card.getState()).isInvalid() || tempState.isConnectedExclusive()) continue;
                    SmartcardPoolMonitor.this.connect(card);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(ISmartcardPoolMonitorListener listener) {
        Log.debug("{} register listener {}", this.getLogPrefix(), (Object)listener);
        Object object = this.lock;
        synchronized (object) {
            boolean needStart = this.listeners.isEmpty();
            this.listeners.add(listener);
            if (needStart) {
                this.start();
            } else {
                this.refresh();
            }
        }
    }

    public void removeReporter(IReporter pReporter) {
        this.reporter.removeReporter(pReporter);
    }

    protected void setReportingFlags(int reportingFlags) {
        this.reportingFlags = reportingFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        Object object = this.lock;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(ISmartcardPoolMonitorListener listener) {
        Log.debug("{} unregister listener {}", this.getLogPrefix(), (Object)listener);
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.stop();
            }
        }
    }
}

