/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.app.authenticate;

import de.intarsys.security.app.AuthenticationCanceled;
import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.AuthenticationTimeout;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.authentication.CommonAuthenticator;
import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.AdditionalCertificateProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationTimeout;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.crypto.Secret;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SmartcardAuthenticator
extends CommonAuthenticator {
    private final IAuthenticateApplication cardApplication;
    private final ICardHolderCertificate certificate;
    private String label;

    protected SmartcardAuthenticator(CommonDevice device, IAuthenticateApplication app) {
        super(device);
        this.cardApplication = app;
        this.certificate = app.getCardHolderCertificate();
        ArrayList<ICardHolderCertificate> result = new ArrayList<ICardHolderCertificate>();
        result.add(this.certificate);
        List sorted = CertificateTools.sortCertificates((Collection)this.certificate.getCACertificates());
        result.addAll(sorted);
        this.setCertificatePath(result.toArray(new IX509PublicKeyCertificate[result.size()]));
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenAccept(ignore -> {
            try {
                this.getCardApplication().setAuthenticationPrompt(this.getAuthenticationPrompt());
                this.getCardApplication().authenticate();
            }
            catch (CardAuthenticationCanceledException e) {
                throw new AuthenticationCanceled(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardAuthenticationFailedException e) {
                throw new AuthenticationFailed(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardAuthenticationTimeout e) {
                throw new AuthenticationTimeout(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardApplicationException e) {
                throw new SecurityApplicationException(e.getLocalizedMessage(), (Throwable)e);
            }
        });
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        if (this.getCardApplication() != null) {
            try {
                this.getCardApplication().reset();
            }
            catch (CardApplicationException e) {
                throw new SecurityApplicationException((Throwable)e);
            }
        }
    }

    protected void basicDispose() {
        super.basicDispose();
        if (this.getCardApplication() != null) {
            try {
                this.getCardApplication().getCardConnection().close(0);
            }
            catch (CardException cardException) {
                // empty catch block
            }
        }
    }

    protected byte[] basicSign(byte[] data) throws SecurityApplicationException {
        try {
            byte[] signature = this.getCardApplication().sign(data);
            this.checkExpectedResult(signature, data);
            return signature;
        }
        catch (SecurityApplicationException e) {
            throw e;
        }
        catch (CardAuthenticationCanceledException e) {
            throw new AuthenticationCanceled(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CardAuthenticationFailedException e) {
            throw new AuthenticationFailed(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CardAuthenticationTimeout e) {
            throw new AuthenticationTimeout(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new SecurityApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildCertificatePath() {
        IX509Certificate[] chain;
        if (this.getCertificate() == null) {
            this.setCertificatePath(new IX509PublicKeyCertificate[0]);
            return;
        }
        CompositeCertificateProvider certificateProvider = new CompositeCertificateProvider();
        CollectionCertificateProvider smartcardCertsProvider = null;
        try {
            certificateProvider.registerCertificateProvider(AdditionalCertificateProvider.get());
            ArrayList smartcardCerts = new ArrayList(this.getCertificate().getCACertificates());
            smartcardCertsProvider = new CollectionCertificateProvider(smartcardCerts);
            certificateProvider.registerCertificateProvider((ICertificateProvider)smartcardCertsProvider);
            chain = ValidationTools.getCertificatePath((IX509Certificate)this.getCertificate(), (boolean)true, (ICertificateProvider)certificateProvider);
        }
        catch (Throwable throwable) {
            certificateProvider.unregisterCertificateProvider(AdditionalCertificateProvider.get());
            certificateProvider.unregisterCertificateProvider(smartcardCertsProvider);
            throw throwable;
        }
        certificateProvider.unregisterCertificateProvider(AdditionalCertificateProvider.get());
        certificateProvider.unregisterCertificateProvider((ICertificateProvider)smartcardCertsProvider);
        if (chain == null || chain.length == 0) {
            this.setCertificatePath(new IX509PublicKeyCertificate[]{this.getCertificate()});
        } else {
            IX509PublicKeyCertificate[] result = new IX509PublicKeyCertificate[chain.length];
            System.arraycopy(chain, 0, result, 0, chain.length);
            this.setCertificatePath(result);
        }
    }

    private void checkExpectedResult(byte[] signature, byte[] bytes) throws SecurityApplicationException {
    }

    protected IAuthenticateApplication getCardApplication() {
        return this.cardApplication;
    }

    protected ICardHolderCertificate getCertificate() {
        return this.certificate;
    }

    public String getLabel() {
        if (this.label == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(CertificateTools.getSubjectLabel((IX509Certificate)this.certificate));
            sb.append(" @ ");
            sb.append(this.getCardApplication().getCardConnection().getCardTerminal().getName());
            this.label = sb.toString();
        }
        return this.label;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.getCardApplication() != null && this.getCardApplication().isValid();
    }

    public void setAuthenticationPin(Secret pin) {
        super.setAuthenticationPin(pin);
        this.getCardApplication().setAuthenticationPin(pin);
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        super.setPasswordProvider(passwordProvider);
        this.getCardApplication().setPasswordProvider(passwordProvider);
    }

    public String toString() {
        return this.getLabel();
    }
}

