/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.app.authenticate;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.smartcard.app.authenticate.SmartcardAuthenticator;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class SmartcardAuthenticatorFactory
extends CommonSecurityApplicationFactory<SmartcardDevice, SmartcardAuthenticator> {
    protected SmartcardAuthenticator basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            return ((SmartcardDevice)this.getDevice(args)).withCardApplication(IAuthenticateApplication.class, args, "signerIdentifier", cardApp -> {
                try {
                    SmartcardAuthenticator app = new SmartcardAuthenticator(this.getDevice(args), (IAuthenticateApplication)cardApp);
                    if (this.isIncludeCertificatePath(args)) {
                        try {
                            app.buildCertificatePath();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ICardHolderCertificate cert = cardApp.getCardHolderCertificate();
                    this.initAuthentication((ISecurityApplication)app, (IX509PublicKeyCertificate)cert, args);
                    return app;
                }
                catch (Exception e) {
                    throw ExceptionTools.wrap((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.unwrapTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    public Class<SmartcardAuthenticator> getResultType() {
        return SmartcardAuthenticator.class;
    }

    public boolean isIncludeCertificatePath(IArgs args) {
        boolean value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificateChain", (boolean)true);
        value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificatePath", (boolean)value);
        return value;
    }
}

