/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.app.decrypt;

import de.intarsys.security.app.AuthenticationCanceled;
import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.AuthenticationTimeout;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.DecryptedData;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.app.decryption.CommonDecryptor;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.app.common.IDecryptApplication;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationTimeout;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.KnownReason;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;

public class SmartcardDecryptor
extends CommonDecryptor {
    private final IDecryptApplication cardApplication;
    private final ICardHolderCertificate certificate;

    public SmartcardDecryptor(SmartcardDevice device, IDecryptApplication app) {
        super((CommonDevice)device);
        this.cardApplication = app;
        this.certificate = app.getCardHolderCertificate();
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenAccept(ignore -> {
            try {
                this.getCardApplication().setAuthenticationPrompt(this.getAuthenticationPrompt());
                this.getCardApplication().authenticate();
            }
            catch (CardAuthenticationCanceledException e) {
                throw new AuthenticationCanceled(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardAuthenticationFailedException e) {
                throw new AuthenticationFailed(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardAuthenticationTimeout e) {
                throw new AuthenticationTimeout(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardApplicationException e) {
                throw new SecurityApplicationException(e.getLocalizedMessage(), (Throwable)e);
            }
        });
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        if (this.getCardApplication() != null) {
            try {
                this.getCardApplication().reset();
            }
            catch (CardApplicationException e) {
                throw new SecurityApplicationException((Throwable)e);
            }
        }
    }

    protected IDecryptedData basicDecrypt(IEncryptedData encryptedData) throws SecurityApplicationException {
        try {
            byte[] encryptedBytes = LocatorTools.getBytes((ILocator)encryptedData.getLocator());
            byte[] decryptedBytes = this.getCardApplication().decrypt(encryptedBytes);
            ByteArrayLocator locator = new ByteArrayLocator(decryptedBytes, "decryptedData", "bin");
            return new DecryptedData((ILocator)locator);
        }
        catch (CardApplicationException e) {
            throw new KnownReason(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    protected void basicDispose() {
        super.basicDispose();
        if (this.getCardApplication() != null) {
            try {
                this.getCardApplication().getCardConnection().close(0);
            }
            catch (CardException cardException) {
                // empty catch block
            }
        }
    }

    public IDecryptApplication getCardApplication() {
        return this.cardApplication;
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.getCardApplication() != null && this.getCardApplication().isValid();
    }

    public void setAuthenticationPin(Secret authenticationPin) {
        super.setAuthenticationPin(authenticationPin);
        this.getCardApplication().setAuthenticationPin(authenticationPin);
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        super.setPasswordProvider(passwordProvider);
        this.getCardApplication().setPasswordProvider(passwordProvider);
    }
}

