/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.app.decrypt;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.smartcard.app.decrypt.SmartcardDecryptor;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.app.common.IDecryptApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class SmartcardDecryptorFactory
extends CommonSecurityApplicationFactory<SmartcardDevice, SmartcardDecryptor> {
    protected SmartcardDecryptor basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            return ((SmartcardDevice)this.getDevice(args)).withCardApplication(IDecryptApplication.class, args, "decryptorIdentifier", cardApp -> {
                try {
                    SmartcardDecryptor app = new SmartcardDecryptor((SmartcardDevice)this.getDevice(args), (IDecryptApplication)cardApp);
                    ICardHolderCertificate cert = cardApp.getCardHolderCertificate();
                    this.initAuthentication((ISecurityApplication)app, (IX509PublicKeyCertificate)cert, args);
                    return app;
                }
                catch (Exception e) {
                    throw ExceptionTools.wrap((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.unwrapTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected String getArgNamePassword() {
        return "decryptorPassword";
    }

    public Class getResultType() {
        return IDecryptor.class;
    }
}

