/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.app.management;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.principal.CommonPrincipalReader;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.device.smartcard.device.SmartcardPrincipal;
import de.intarsys.security.smartcard.app.common.IExtractCertificateApplication;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardPublicKeyCertificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SmartcardPrincipalReader
extends CommonPrincipalReader {
    private final IExtractCertificateApplication cardApplication;
    private String label;

    public SmartcardPrincipalReader(SmartcardDevice device, IExtractCertificateApplication app) {
        super((CommonDevice)device);
        this.cardApplication = app;
    }

    protected void basicDispose() {
        super.basicDispose();
        if (this.getCardApplication() != null) {
            try {
                this.getCardApplication().getCardConnection().close(0);
            }
            catch (CardException cardException) {
                // empty catch block
            }
        }
    }

    protected IPrincipal createPrincipal(ICardPublicKeyCertificate cert) {
        SmartcardPrincipal principal = this.getDevice().createPrincipal((IX509PublicKeyCertificate)cert);
        return principal;
    }

    protected IExtractCertificateApplication getCardApplication() {
        return this.cardApplication;
    }

    public SmartcardDevice getDevice() {
        return (SmartcardDevice)super.getDevice();
    }

    public String getLabel() {
        if (this.label == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCardApplication().getCardConnection().getCardTerminal().getName());
            this.label = sb.toString();
        }
        return this.label;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.getCardApplication() != null && this.getCardApplication().isValid();
    }

    protected List<ICardPublicKeyCertificate> loadCertificates(ICardApplication app) {
        return ((IExtractCertificateApplication)app).getPublicKeyCertificates();
    }

    public Iterator<IPrincipal> loadPrincipals() throws SecurityApplicationException {
        return this.loadPrincipals((ICardApplication)this.getCardApplication()).iterator();
    }

    protected List<IPrincipal> loadPrincipals(ICardApplication app) {
        List<ICardPublicKeyCertificate> certs = this.loadCertificates(app);
        if (certs == null || certs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IPrincipal> principals = new ArrayList<IPrincipal>();
        for (ICardPublicKeyCertificate cert : certs) {
            IPrincipal principal = this.createPrincipal(cert);
            if (principal == null) continue;
            principals.add(principal);
        }
        return principals;
    }

    public String toString() {
        return this.getLabel();
    }
}

