/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.app.signature;

import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.app.AuthenticationCanceled;
import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.AuthenticationTimeout;
import de.intarsys.security.app.ManipulationException;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonSingleSigner;
import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.AdditionalCertificateProvider;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.environment.SmartcardEnvironment;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationTimeout;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.activity.RequestPassword;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationSupport;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SmartcardSigner
extends CommonSingleSigner {
    private final ISignApplication cardApplication;
    private final ICardHolderCertificate certificate;
    private String label;

    public SmartcardSigner(SmartcardDevice device, ISignApplication app) {
        super((CommonDevice)device);
        this.cardApplication = app;
        this.certificate = app.getCardHolderCertificate();
        ArrayList<ICardHolderCertificate> result = new ArrayList<ICardHolderCertificate>();
        result.add(this.certificate);
        List sorted = CertificateTools.sortCertificates((Collection)this.certificate.getCACertificates());
        result.addAll(sorted);
        this.setCertificatePath(result.toArray(new IX509PublicKeyCertificate[result.size()]));
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenCompose(ignore -> {
            if (this.isRequestPin()) {
                RequestPassword requester = RequestPassword.create(null, (IMessage)this.getAuthenticationTitle(), (IMessage)this.getAuthenticationPromptExpanded());
                IActivityView view = requester.enter();
                return ((IConversationSupport)view).getConversation();
            }
            return Conversation.completed(null);
        }).thenAccept(secret -> {
            try {
                if (!CryptoTools.isEmpty((Secret)secret)) {
                    this.getCardApplication().setAuthenticationPin(secret);
                }
                this.getCardApplication().setAuthenticationPrompt(this.getAuthenticationPrompt());
                this.getCardApplication().authenticate();
            }
            catch (CardAuthenticationCanceledException e) {
                throw new AuthenticationCanceled(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardAuthenticationFailedException e) {
                throw new AuthenticationFailed(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardAuthenticationTimeout e) {
                throw new AuthenticationTimeout(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CardApplicationException e) {
                throw new SecurityApplicationException(e.getLocalizedMessage(), (Throwable)e);
            }
        });
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        if (this.getCardApplication() != null) {
            try {
                this.getCardApplication().reset();
            }
            catch (CardApplicationException e) {
                throw new SecurityApplicationException((Throwable)e);
            }
        }
    }

    protected void basicDispose() {
        super.basicDispose();
        if (this.getCardApplication() != null) {
            try {
                this.getCardApplication().reset();
            }
            catch (CardApplicationException cardApplicationException) {
                // empty catch block
            }
            try {
                this.getCardApplication().getCardConnection().close(0);
            }
            catch (CardException cardException) {
                // empty catch block
            }
        }
    }

    protected void basicSignCheckAccess() {
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        try {
            byte[] signature = this.getCardApplication().sign(data.getEncodedDigest());
            this.checkExpectedResult(signature, data.getEncodedDigest());
            return Conversation.completed((Object)SignatureData.create((byte[])signature));
        }
        catch (SecurityApplicationException e) {
            return Conversation.failed((Throwable)e);
        }
        catch (CardAuthenticationCanceledException e) {
            return Conversation.failed((Throwable)new AuthenticationCanceled(e.getLocalizedMessage(), (Throwable)e));
        }
        catch (CardAuthenticationFailedException e) {
            return Conversation.failed((Throwable)new AuthenticationFailed(e.getLocalizedMessage(), (Throwable)e));
        }
        catch (CardAuthenticationTimeout e) {
            return Conversation.failed((Throwable)new AuthenticationTimeout(e.getLocalizedMessage(), (Throwable)e));
        }
        catch (Exception e) {
            this.dispose();
            return Conversation.failed((Throwable)new SecurityApplicationException(e.getLocalizedMessage(), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildCertificatePath() {
        IX509Certificate[] chain;
        if (this.getCertificate() == null) {
            this.setCertificatePath(new IX509PublicKeyCertificate[0]);
            return;
        }
        CompositeCertificateProvider certificateProvider = new CompositeCertificateProvider();
        CollectionCertificateProvider smartcardCertsProvider = null;
        try {
            certificateProvider.registerCertificateProvider(AdditionalCertificateProvider.get());
            ArrayList smartcardCerts = new ArrayList(this.getCertificate().getCACertificates());
            smartcardCertsProvider = new CollectionCertificateProvider(smartcardCerts);
            certificateProvider.registerCertificateProvider((ICertificateProvider)smartcardCertsProvider);
            chain = ValidationTools.getCertificatePath((IX509Certificate)this.getCertificate(), (boolean)true, (ICertificateProvider)certificateProvider);
        }
        catch (Throwable throwable) {
            certificateProvider.unregisterCertificateProvider(AdditionalCertificateProvider.get());
            certificateProvider.unregisterCertificateProvider(smartcardCertsProvider);
            throw throwable;
        }
        certificateProvider.unregisterCertificateProvider(AdditionalCertificateProvider.get());
        certificateProvider.unregisterCertificateProvider((ICertificateProvider)smartcardCertsProvider);
        if (chain == null || chain.length == 0) {
            this.setCertificatePath(new IX509PublicKeyCertificate[]{this.getCertificate()});
        } else {
            IX509PublicKeyCertificate[] result = new IX509PublicKeyCertificate[chain.length];
            System.arraycopy(chain, 0, result, 0, chain.length);
            this.setCertificatePath(result);
        }
    }

    private void checkExpectedResult(byte[] signature, byte[] bytes) throws SecurityApplicationException {
        if (!PpkTools.validate((byte[])signature, (PublicKey)this.getCertificate().getPublicKey(), (AlgorithmParameterSpec)this.getAlgorithmParameterSpec(), (byte[])bytes)) {
            throw new ManipulationException();
        }
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return this.getDevice().createPrincipal(certificate);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.getCardApplication().getAlgorithmParameterSpec();
    }

    protected IMessage getAuthenticationPromptExpanded() {
        return this.getCardApplication().getAuthenticationPromptExpanded();
    }

    public ISignApplication getCardApplication() {
        return this.cardApplication;
    }

    public ICardHolderCertificate getCertificate() {
        return this.certificate;
    }

    public SmartcardDevice getDevice() {
        return (SmartcardDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return this.getCardApplication().getEncryptionAlgorithmName();
    }

    public String getLabel() {
        if (this.label == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(CertificateTools.getSubjectLabel((IX509Certificate)this.certificate));
            sb.append(" / ");
            sb.append(this.certificate.getSerialNumber());
            sb.append(" @ ");
            sb.append(this.getCardApplication().getCardConnection().getCardTerminal().getName());
            this.label = sb.toString();
        }
        return this.label;
    }

    public String getPreferredHashAlgorithmName() {
        return SmartcardEnvironment.get().getSignatureHashAlgorithm();
    }

    public int getRestrictionCount() {
        int restriction = super.getRestrictionCount();
        int cardRestriction = this.getCardApplication().getRestrictionCount();
        if (restriction < 0) {
            return cardRestriction;
        }
        if (cardRestriction < 0) {
            return restriction;
        }
        return Math.min(restriction, cardRestriction);
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return this.getCardApplication().getSupportedHashAlgorithmNames();
    }

    public boolean isBasic() {
        return true;
    }

    protected boolean isRequestPin() {
        if (!CryptoTools.isEmpty((Secret)this.getAuthenticationPin())) {
            return false;
        }
        if (this.getCardApplication().isSupportedSPE()) {
            return false;
        }
        return !this.getCardApplication().isEnforceSPE();
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.getCardApplication() != null && this.getCardApplication().isValid();
    }

    public void setAuthenticationPin(Secret authenticationPin) {
        super.setAuthenticationPin(authenticationPin);
        this.getCardApplication().setAuthenticationPin(authenticationPin);
    }

    public void setHashAlgorithmName(String hashAlgorithmName) throws SecurityApplicationException {
        super.setHashAlgorithmName(hashAlgorithmName);
        try {
            this.getCardApplication().setHashAlgorithmName(hashAlgorithmName);
        }
        catch (CardApplicationException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        super.setPasswordProvider(passwordProvider);
        this.getCardApplication().setPasswordProvider(passwordProvider);
    }

    public String toString() {
        return this.getLabel();
    }
}

