/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.app.signature;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.smartcard.app.signature.SmartcardSigner;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class SmartcardSignerFactory
extends CommonSignerFactory<SmartcardDevice, SmartcardSigner> {
    protected SmartcardSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            return ((SmartcardDevice)this.getDevice(args)).withCardApplication(ISignApplication.class, args, "signerIdentifier", cardApp -> {
                try {
                    SmartcardSigner app = new SmartcardSigner((SmartcardDevice)this.getDevice(args), (ISignApplication)cardApp);
                    if (this.isIncludeCertificatePath(args)) {
                        try {
                            app.buildCertificatePath();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ICardHolderCertificate cert = cardApp.getCardHolderCertificate();
                    this.initAuthentication((ISecurityApplication)app, (IX509PublicKeyCertificate)cert, args);
                    return app;
                }
                catch (Exception e) {
                    throw ExceptionTools.wrap((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.unwrapTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    public Class<SmartcardSigner> getResultType() {
        return SmartcardSigner.class;
    }

    protected boolean isIncludeCertificatePath(IArgs args) {
        boolean value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificateChain", (boolean)true);
        value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificatePath", (boolean)value);
        return value;
    }
}

