/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.device.smartcard.device.PACKAGE;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.app.common.ICardStateApplication;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.concurrent.AbstractFutureTask;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskExecutionException;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.message.AliasMessage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.notice.Notice;
import de.intarsys.tools.notice.NoticeTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCardArtifactSelector<A>
extends AbstractFutureTask<A>
implements IElementConfigurable {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    protected static final Logger Log = LoggerFactory.getLogger(AbstractCardArtifactSelector.class);
    public static final String ATR_CARDSERIALNUMBER = "cardSerialNumber";
    private static final String CFG_CARD_APPLICATION_TYPE = "cardApplicationType";
    private static final String CFG_CARD_SERIAL_NUMBER = "cardFilterProperties.serialNumber";
    private static final INotice NOTICE_CONNECT = new Notice(10, false, (IMessage)new AliasMessage(NoticeTools.getActivityCode((String)"connect", null), Msg.getMessage("AbstractCardArtifactSelector.StateConnect", new Object[0]), new Object[0]));
    private static final INotice NOTICE_READ = new Notice(10, false, (IMessage)new AliasMessage(NoticeTools.getActivityCode((String)"readCard", null), Msg.getMessage("AbstractCardArtifactSelector.StateRead", new Object[0]), new Object[0]));
    private static final INotice NOTICE_CARD_IDENTIFIED = new Notice(10, false, (IMessage)new AliasMessage(NoticeTools.getActivityCode((String)"readArtifacts", null), Msg.getMessage("AbstractCardArtifactSelector.StateCardIdentified", new Object[0]), new Object[0]));
    private final SmartcardDevice device;
    private Class<? extends ICardApplication> cardApplicationType;
    private String cardSerialNumber;

    public AbstractCardArtifactSelector(SmartcardDevice device) {
        this.device = device;
    }

    protected boolean checkCardSerialNumber(ICardProduct product, ICardConnection connection) throws Exception {
        ICardStateApplication app = (ICardStateApplication)product.createCardApplication(connection, ICardStateApplication.class);
        String serialNumber = app.getSerialNumber();
        this.getDevice().setValue(ATR_CARDSERIALNUMBER, serialNumber);
        if (StringTools.isEmpty((String)this.getCardSerialNumber())) {
            return true;
        }
        boolean match = app.matchSerialNumber(this.getCardSerialNumber());
        if (!match) {
            Log.debug("{} expected card serial number '{}', but found number '{}'", new Object[]{this.getLabel(), this.cardSerialNumber, app.getSerialNumber()});
        }
        return match;
    }

    protected A compute() throws Exception {
        this.tryFetch();
        return null;
    }

    public void configure(IElement element) throws ConfigurationException {
        IElement configArgs = element;
        String cardApplicationName = ElementTools.getString((IElement)configArgs, (String)CFG_CARD_APPLICATION_TYPE, null);
        if (!StringTools.isEmpty((String)cardApplicationName)) {
            try {
                this.cardApplicationType = ClassTools.createClass((String)cardApplicationName, ICardApplication.class, null);
            }
            catch (ObjectCreationException e) {
                Log.error("{} can't load ICardApplication {}", (Object)this.getLabel(), (Object)cardApplicationName);
                throw new ConfigurationException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        configArgs = this.getDevice().getConfiguration();
        this.cardSerialNumber = ElementTools.getPathString((IElement)configArgs, (String)CFG_CARD_SERIAL_NUMBER, (String)this.cardSerialNumber);
    }

    protected abstract A createCardArtifactDefault();

    public Class<? extends ICardApplication> getCardApplicationType() {
        return this.cardApplicationType;
    }

    public String getCardSerialNumber() {
        return this.cardSerialNumber;
    }

    protected SmartcardDevice getDevice() {
        return this.device;
    }

    protected A getFailedArtifact() {
        return this.createCardArtifactDefault();
    }

    protected abstract String getTargetAttribute();

    public boolean isAsynch() {
        return true;
    }

    /*
     * Exception decompiling
     */
    protected void onConnected(ICardConnection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void onConnectionFailed(TaskFailed exception) {
        boolean retry;
        this.getDevice().removeNotice(NOTICE_CONNECT);
        if (exception.isCancellation()) {
            this.cancel(false);
            return;
        }
        Throwable cause = exception.getCause();
        ICard card = this.getDevice().getCard();
        if (card != null && (retry = CardTools.isRetry((ICard)card, (Throwable)exception, (int)2))) {
            Log.info("{} connect {} failed ({}), retry", new Object[]{this.getLabel(), card, ExceptionTools.getMessage((Throwable)cause)});
            this.tryFetch();
            return;
        }
        Log.warn("{} connect {} failed", new Object[]{this.getLabel(), card, cause});
        String code = NoticeTools.getActivityCode((String)AtomicState.FAILED.getId(), (String)this.getTargetAttribute());
        IMessage msg = Msg.getMessage("AbstractCardArtifactSelector.ErrorReadingArtifacts", new Object[0]);
        Notice notice = new Notice(30, true, code, msg.getString(), new Object[]{cause});
        NoticeTools.setNotice((INoticesSupport)this.getDevice(), (INotice)notice);
        this.setResult(this.getFailedArtifact());
    }

    protected abstract A selectCardArtifacts(ICardProduct var1, ICardConnection var2) throws CardApplicationException;

    public void setCardApplicationType(Class<? extends ICardApplication> cardApplicationType) {
        this.cardApplicationType = cardApplicationType;
    }

    public void setCardSerialNumber(String pCardSerialNumber) {
        this.cardSerialNumber = StringTools.isEmpty((String)pCardSerialNumber) ? null : pCardSerialNumber.trim();
    }

    protected void tryConnect() {
        try {
            ICard card = this.getDevice().getCard();
            if (card == null || card.getState().isInvalid()) {
                this.setResult(null);
                return;
            }
            Log.debug("{} {} connect", (Object)this.getLabel(), (Object)card);
            this.getDevice().addNotice(NOTICE_CONNECT);
            CardTools.connectTransacted((ICard)card, (ITaskCallback)new ITaskCallback<ICardConnection>(){

                public void failed(TaskFailed exception) {
                    AbstractCardArtifactSelector.this.onConnectionFailed(exception);
                }

                public void finished(ICardConnection connection) {
                    AbstractCardArtifactSelector.this.onConnected(connection);
                }
            });
        }
        catch (Exception e) {
            this.onConnectionFailed((TaskFailed)new TaskExecutionException((Throwable)e));
        }
    }

    protected void tryFetch() {
        if (this.isCancelled()) {
            return;
        }
        if (!this.tryLookup()) {
            this.tryConnect();
        }
    }

    protected boolean tryLookup() {
        return false;
    }
}

