/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.concurrent.AbstractFutureTask;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskExecutionException;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCardTerminalArtifactSelector<A>
extends AbstractFutureTask<A>
implements IElementConfigurable {
    private static final Logger Log = LoggerFactory.getLogger(AbstractCardTerminalArtifactSelector.class);
    private final SmartcardDevice device;
    private int retries = 0;

    public AbstractCardTerminalArtifactSelector(SmartcardDevice device) {
        this.device = device;
    }

    protected A compute() throws Exception {
        this.tryConnect();
        return null;
    }

    public void configure(IElement element) throws ConfigurationException {
    }

    protected A createCardArtifactDefault() {
        return null;
    }

    protected A getCachedArtifact() {
        return null;
    }

    protected SmartcardDevice getDevice() {
        return this.device;
    }

    protected A getFailedArtifact(CardApplicationException exception) {
        return null;
    }

    protected int getRetries() {
        return this.retries;
    }

    protected boolean isArtifactCached() {
        return false;
    }

    public boolean isAsynch() {
        return true;
    }

    protected void onConnected(ICardConnection connection) {
        Log.debug("{} {} established", (Object)this.getLabel(), (Object)connection);
        ICard card = connection.getCard();
        A result = this.createCardArtifactDefault();
        try {
            if (!this.isCancelled()) {
                result = this.selectCardArtifacts(connection);
            }
            connection.close(0);
            CardTools.resetRetry((ICard)card);
        }
        catch (Exception e) {
            boolean retry = CardTools.isRetry((ICard)card, (Throwable)e, (int)2);
            if (retry) {
                Log.info("{} {} select artifacts failed ({}), retry", new Object[]{this.getLabel(), connection, ExceptionTools.getMessage((Throwable)e)});
                this.tryConnect();
                return;
            }
            Log.warn("{} {} select artifacts failed", new Object[]{this.getLabel(), connection, e});
            result = this.getFailedArtifact(CardApplicationException.create((Throwable)e));
            try {
                connection.close(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setResult(result);
    }

    protected void onConnectionFailed(ICard card, Throwable e) {
        boolean retry = CardTools.isRetry((ICard)card, (Throwable)e, (int)2);
        if (retry) {
            Log.info("{} {} connect failed ({}), retry", new Object[]{this.getLabel(), card, ExceptionTools.getMessage((Throwable)e)});
            this.tryConnect();
            return;
        }
        Log.info("{} {} connect failed", new Object[]{this.getLabel(), card, e});
        this.setResult(this.getFailedArtifact(CardApplicationException.create((Throwable)e)));
    }

    protected void onConnectionFailed(TaskFailed exception) {
        if (exception.isCancellation()) {
            this.cancel(false);
            return;
        }
        Throwable cause = exception.getCause();
        ICard card = this.getDevice().getCard();
        this.onConnectionFailed(card, cause);
    }

    protected abstract A selectCardArtifacts(ICardConnection var1) throws CardApplicationException;

    protected void tryConnect() {
        try {
            if (this.isCancelled()) {
                return;
            }
            if (this.isArtifactCached()) {
                this.setResult(this.getCachedArtifact());
                return;
            }
            ICardTerminal cardTerminal = this.getDevice().getCardTerminal();
            if (cardTerminal == null || cardTerminal.getState().isInvalid()) {
                this.setResult(null);
                return;
            }
            try {
                Log.trace("{} connect {}", (Object)this.getLabel(), (Object)cardTerminal);
                ICardConnection connection = cardTerminal.connectDirect();
                this.onConnected(connection);
            }
            catch (Exception e) {
                Log.trace("{} connect {} failed ({})", new Object[]{this.getLabel(), cardTerminal, ExceptionTools.getMessage((Throwable)e)});
                ICard card = cardTerminal.getCard();
                if (card == null || card.getState().isInvalid()) {
                    this.onConnectionFailed(null, e);
                    return;
                }
                Log.trace("{} connect {} instead", (Object)this.getLabel(), (Object)card);
                CardTools.connectTransacted((ICard)card, (ITaskCallback)new ITaskCallback<ICardConnection>(){

                    public void failed(TaskFailed exception) {
                        AbstractCardTerminalArtifactSelector.this.onConnectionFailed(exception);
                    }

                    public void finished(ICardConnection connection) {
                        AbstractCardTerminalArtifactSelector.this.onConnected(connection);
                    }
                });
            }
        }
        catch (Exception e) {
            this.onConnectionFailed((TaskFailed)new TaskExecutionException((Throwable)e));
        }
    }
}

