/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.smartcard.device.AbstractCardArtifactSelector;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.device.smartcard.device.SmartcardPrincipal;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardCertificate;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardPublicKeyCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CommonPrincipalSelector
extends AbstractCardArtifactSelector<List<IPrincipal>> {
    public CommonPrincipalSelector(SmartcardDevice device) {
        super(device);
    }

    @Override
    protected List<IPrincipal> createCardArtifactDefault() {
        return Collections.emptyList();
    }

    protected IPrincipal createPrincipal(ICardPublicKeyCertificate cert) {
        SmartcardPrincipal principal = this.getDevice().createPrincipal((IX509PublicKeyCertificate)cert);
        return principal;
    }

    protected List<ICardPublicKeyCertificate> filter(List<ICardPublicKeyCertificate> certs) {
        if (certs == null || certs.isEmpty()) {
            return Collections.emptyList();
        }
        return certs;
    }

    @Override
    protected String getTargetAttribute() {
        return "principals";
    }

    protected List<IPrincipal> mapCertificates(List<ICardPublicKeyCertificate> certs) {
        if (certs == null || certs.isEmpty()) {
            return Collections.emptyList();
        }
        if ((certs = this.filter(certs)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IPrincipal> principals = new ArrayList<IPrincipal>();
        for (ICardPublicKeyCertificate cert : certs) {
            IPrincipal principal = this.createPrincipal(cert);
            if (principal == null) continue;
            principals.add(principal);
        }
        return principals;
    }

    @Override
    protected List<IPrincipal> selectCardArtifacts(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        ICardApplication app = product.createCardApplication(connection, this.getCardApplicationType());
        return this.selectPrincipals(app);
    }

    protected List<ICardPublicKeyCertificate> selectCertificates(ICardApplication app) {
        return new ArrayList<ICardPublicKeyCertificate>();
    }

    protected List<IPrincipal> selectPrincipals(ICardApplication app) {
        List<ICardPublicKeyCertificate> certs = this.selectCertificates(app);
        return this.mapCertificates(certs);
    }

    @Override
    protected boolean tryLookup() {
        List cached = CardCertificate.getPKCardCertificates((ICard)this.getDevice().getCard());
        if (cached != null) {
            this.setResult(this.mapCertificates(cached));
            return true;
        }
        return super.tryLookup();
    }
}

