/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.smartcard.device.AbstractCardArtifactSelector;
import de.intarsys.security.device.smartcard.device.SmartcardCredential;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.app.common.IPinStateApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CredentialSelector
extends AbstractCardArtifactSelector<List<ICredential>> {
    public CredentialSelector(SmartcardDevice device) {
        super(device);
        this.created();
    }

    @Override
    protected List<ICredential> createCardArtifactDefault() {
        return Collections.emptyList();
    }

    @Override
    public Class<? extends ICardApplication> getCardApplicationType() {
        return IPinStateApplication.class;
    }

    @Override
    protected String getTargetAttribute() {
        return "credentials";
    }

    @Override
    protected List<ICredential> selectCardArtifacts(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        IPinStateApplication app = (IPinStateApplication)product.createCardApplication(connection, this.getCardApplicationType());
        ArrayList<ICredential> result = new ArrayList<ICredential>();
        for (IPinInfo pinInfo : app.getSupportedPinInfos()) {
            SmartcardCredential cred = new SmartcardCredential(this.getDevice(), pinInfo);
            cred.updatePinState(connection);
            result.add((ICredential)cred);
        }
        return result;
    }
}

