/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.app.PrincipalNotFoundException;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.smartcard.device.DispatchSmartcardDevice;
import de.intarsys.security.device.smartcard.device.DispatchSmartcardDeviceProvider;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.certificate.SmartcardSelectCertificateProvider;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.KnownReason;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;
import java.util.function.Function;

public class DispatchSmartcardAppFactory<T extends CommonSecurityApplication>
extends CommonSecurityApplicationFactory<DispatchSmartcardDevice, T> {
    private Class<? extends ICardApplication> cardApplicationType;
    private String certificateIdentifierArgName;

    protected SmartcardDevice createDelegateDevice(IArgs args, ICardApplication app) throws ObjectCreationException {
        return ((DispatchSmartcardDeviceProvider)((DispatchSmartcardDevice)this.getDevice(args)).getDeviceProvider()).createSmartcardDevice(app.getCard().getCardTerminal());
    }

    public T createInstance(IArgs args) throws ObjectCreationException {
        try {
            return (T)this.withCardApplication(args, cardApp -> {
                try {
                    SmartcardDevice device = this.createDelegateDevice(args, (ICardApplication)cardApp);
                    args.put("cardApplication", cardApp);
                    return (CommonSecurityApplication)device.createApplication(this.getType().getName(), args);
                }
                catch (ObjectCreationException e) {
                    throw ExceptionTools.wrap((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.unwrapTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    public Class<? extends ICardApplication> getCardApplicationType() {
        return this.cardApplicationType;
    }

    public String getCertificateIdentifierArgName() {
        return this.certificateIdentifierArgName;
    }

    public void setCardApplicationType(Class<? extends ICardApplication> cardApplicationType) {
        this.cardApplicationType = cardApplicationType;
    }

    public void setCertificateIdentifierArgName(String certificateIdentifierArgName) {
        this.certificateIdentifierArgName = certificateIdentifierArgName;
    }

    protected <R> R withCardApplication(IArgs args, Function<ICardHolderApplication, R> function) throws Exception {
        ICardHolderApplication app = (ICardHolderApplication)ArgTools.getObject((IArgs)args, (String)"cardApplication", null);
        if (app != null) {
            return function.apply(app);
        }
        IX509CertificateFilter selector = CertificateFilterTools.getCertificateFilter((IArgs)args, (String)this.getCertificateIdentifierArgName());
        SmartcardSelectCertificateProvider provider = new SmartcardSelectCertificateProvider();
        if (selector == null) {
            selector = AllCertificateFilter.UNIQUE;
        }
        boolean interactive = ArgTools.getBoolStrict((IArgs)args, (String)"signerSelectionUI", (boolean)false);
        interactive = ArgTools.getBoolStrict((IArgs)args, (String)"signerSelectionInteractive", (boolean)interactive);
        provider.setSelectionInteractive(interactive);
        boolean unique = ArgTools.getBoolStrict((IArgs)args, (String)"signerSelectionUnique", (boolean)false);
        provider.setSelectionUnique(unique);
        Class<ICardApplication> appType = this.getCardApplicationType();
        provider.setSecurityApplication(appType);
        provider.setCardTerminal(ArgTools.getString((IArgs)args, (String)"cardTerminal", null));
        provider.setCloseConnections(false);
        Iterator it = provider.lookupCertificates(selector);
        IX509Certificate certificate = null;
        if (it.hasNext()) {
            certificate = (IX509Certificate)it.next();
        }
        if (certificate == null) {
            throw new PrincipalNotFoundException("no certificate found", (Throwable)new KnownReason());
        }
        app = (ICardHolderApplication)provider.getCardApplication(certificate);
        try {
            ICardHolderCertificate cert = provider.getCardHolderCertificate(certificate);
            app.setCardHolderCertificate(cert);
            return function.apply(app);
        }
        catch (Exception e) {
            try {
                app.getCardConnection().close(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

