/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.authentication.IAuthenticator;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.smartcard.device.DispatchSmartcardAppFactory;
import de.intarsys.security.device.smartcard.device.DispatchSmartcardDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDeviceProvider;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.app.common.IDecryptApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.environment.SmartcardEnvironment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class DispatchSmartcardDeviceProvider
extends CommonDeviceProvider<DispatchSmartcardDevice> {
    private SmartcardDeviceProvider smartcardDeviceProvider;

    protected DispatchSmartcardDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        return new DispatchSmartcardDevice(this, this.getId(args));
    }

    public SmartcardDevice createSmartcardDevice(ICardTerminal terminal) throws ObjectCreationException {
        return this.getSmartcardDeviceProvider().createInstance(terminal);
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        DispatchSmartcardAppFactory descriptor = new DispatchSmartcardAppFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setCardApplicationType(ISignApplication.class);
        descriptor.setCertificateIdentifierArgName("signerIdentifier");
        CommonSignerPolicy policy = new CommonSignerPolicy((CommonDeviceProvider)this);
        descriptor.setPolicy((IApplicationPolicy)policy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new DispatchSmartcardAppFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setCardApplicationType(IAuthenticateApplication.class);
        descriptor.setCertificateIdentifierArgName("signerIdentifier");
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IAuthenticator.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new DispatchSmartcardAppFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setCardApplicationType(IDecryptApplication.class);
        descriptor.setCertificateIdentifierArgName("decryptorIdentifier");
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IDecryptor.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    public SmartcardDeviceProvider getSmartcardDeviceProvider() {
        return this.smartcardDeviceProvider;
    }

    @PostConstruct
    public void init() {
        super.init();
        this.setAllowSecretFromAPI(!SmartcardEnvironment.get().isEnforcePinEntry());
        this.setAllowSecretFromCache(SmartcardEnvironment.get().isEnablePinCache());
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
        try {
            this.registerDevice((DispatchSmartcardDevice)this.createInstance((IArgs)Args.create()));
            SmartcardDeviceProvider provider = (SmartcardDeviceProvider)((Object)DeviceTools.lookupDeviceProvider(SmartcardDeviceProvider.class));
            this.setSmartcardDeviceProvider(provider);
        }
        catch (ObjectCreationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setSmartcardDeviceProvider(SmartcardDeviceProvider smartcardDeviceProvider) {
        this.smartcardDeviceProvider = smartcardDeviceProvider;
    }
}

