/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.common.CommonCredential;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.app.common.IPinStateApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.common.PinStateUnknown;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;

public class SmartcardCredential
extends CommonCredential {
    private final IPinInfo pinInfo;
    private PinState pinState;

    protected SmartcardCredential(SmartcardDevice device, IPinInfo pinInfo) {
        super((IDevice)device, pinInfo.getId());
        this.pinInfo = pinInfo;
        this.pinState = new PinStateUnknown(pinInfo);
    }

    public SmartcardDevice getDevice() {
        return (SmartcardDevice)super.getDevice();
    }

    public String getLabel() {
        return this.getPinInfo().getLabel();
    }

    public String getName() {
        return this.getPinInfo().getId();
    }

    public IPinInfo getPinInfo() {
        return this.pinInfo;
    }

    public ICredential getResettingCredential() {
        return null;
    }

    public int getRetries() {
        return this.pinState.getRetries();
    }

    public boolean isActive() {
        return this.pinState.isActive();
    }

    public boolean isChangeable() {
        if (this.pinInfo.isFixed()) {
            return false;
        }
        return this.pinState.isChangeable();
    }

    public boolean isInitializable() {
        if (this.pinInfo.isFixed()) {
            return false;
        }
        return this.pinState.isInitializable();
    }

    public boolean isResettable() {
        if (this.pinInfo.isFixed()) {
            return false;
        }
        return this.pinState.isResettable();
    }

    public boolean isVerifiable() {
        return this.pinState.isVerifiable();
    }

    public void updatePinState(ICardConnection connection) throws CardApplicationException {
        try {
            ICardProduct product = CardProductTools.getCardProduct((ICardConnection)connection);
            IPinStateApplication app = (IPinStateApplication)product.createCardApplication(connection, IPinStateApplication.class);
            this.pinState = app.getPinState(this.pinInfo);
        }
        catch (CardApplicationException e) {
            this.pinState = new PinStateUnknown(this.pinInfo);
            throw e;
        }
    }
}

