/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CertificatePeriodValidator;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.smartcard.device.CardTerminalStateSelector;
import de.intarsys.security.device.smartcard.device.CommonPrincipalSelector;
import de.intarsys.security.device.smartcard.device.CredentialSelector;
import de.intarsys.security.device.smartcard.device.PACKAGE;
import de.intarsys.security.device.smartcard.device.PrincipalSelectorAllCertificates;
import de.intarsys.security.device.smartcard.device.SmartcardDeviceProvider;
import de.intarsys.security.device.smartcard.device.SmartcardPrincipal;
import de.intarsys.security.smartcard.card.CardEvent;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CardTerminalState;
import de.intarsys.security.smartcard.cardterminal.CardTerminalTools;
import de.intarsys.security.smartcard.cardterminal.FeatureList;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskCallbackAdapter;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.AliasMessage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.notice.Notice;
import de.intarsys.tools.notice.NoticeTools;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.validation.IValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=SmartcardDeviceProvider.class)
public class SmartcardDevice
extends CommonDevice<SmartcardDeviceProvider> {
    private static int counter = 0;
    public static final String EA_ACTION_DEFAULT = "default";
    public static final String EA_DEBUG = "debug";
    public static final String EA_ACTION = "action";
    public static final String EA_VALUE = "value";
    public static final String PROP_CARD_TERMINAL_STATE = "cardTerminalState";
    private static final String PROP_CARD_TERMINAL_IS_SPE = "cardTerminalIsSPE";
    public static final String PROP_CARD_PRODUCT_ID = "cardProductId";
    public static final String PROP_CARD_SERIAL_NUMBER = "cardSerialNumber";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Attribute ATTR_PRINCIPAL = new Attribute("principal");
    public static final String CFG_PRINCIPAL_SELECTOR = "principalSelector";
    public static final String CFG_CREDENTIAL_SELECTOR = "credentialSelector";
    public static final String CFG_CLASS = "class";
    private static final String CFG_AUTOSTART = "autostart";
    private static final Logger Log = LoggerFactory.getLogger(SmartcardDevice.class);
    private static final String CFG_PRINCIPAL_VALIDATION = "principalValidation";
    public static final String ARG_SIGNER_SELECTION_UNIQUE = "signerSelectionUnique";
    public static final String ARG_SIGNER_SELECTION_INTERACTIVE = "signerSelectionInteractive";
    public static final String ARG_SIGNER_SELECTION_UI = "signerSelectionUI";
    public static final String ARG_CARD_APPLICATION = "cardApplication";
    public static final String ARG_CARD_TERMINAL = "cardTerminal";
    public static final String ARG_CARD_APPLICATION_TYPE = "cardApplicationType";
    public static final String ARG_CARD_CONNECTION = "cardConnection";
    public static final String LIC_PRODUCT = "de.intarsys.security.device.smartcard";
    private final ICardTerminal cardTerminal;
    private final INotificationListener listenCardEvent = new INotificationListener(){

        public void handleEvent(Event event) {
            SmartcardDevice.this.onCardEvent((CardEvent)event);
        }
    };
    private int connectTimeout = 10000;
    private final Attribute attrPrincipalSelector = new Attribute("principalSelector");
    private final Attribute attrCredentialSelector = new Attribute("credentialSelector");
    private boolean credentialSelectorAutostart = false;
    private boolean principalSelectorAutostart = false;
    private CertificatePeriodValidator validator;
    private CardTerminalStateSelector selector;

    public static ICardHolderCertificate getCertificate(ICardHolderApplication app, IArgs args, String identifier) throws CardApplicationException {
        IX509CertificateFilter selector = null;
        if (args.isDefined(identifier)) {
            try {
                selector = CertificateFilterTools.getCertificateFilter((IArgs)args, (String)identifier);
            }
            catch (Exception e) {
                throw CardApplicationException.create((Throwable)e);
            }
            if (selector == null) {
                throw new CardApplicationException("certificate not found");
            }
        }
        Collection certs = app.getSupportedCardHolderCertificates();
        for (ICardHolderCertificate cert : certs) {
            if (selector != null && !selector.accept((IX509Certificate)cert)) continue;
            return cert;
        }
        throw new CardApplicationException("certificate not found");
    }

    public static ICardHolderCertificate getSignerCertificate(ICardHolderApplication app, IArgs args) throws CardApplicationException {
        try {
            return SmartcardDevice.getCertificate(app, args, "signerIdentifier");
        }
        catch (Exception e) {
            return SmartcardDevice.getCertificate(app, args, "principal");
        }
    }

    protected SmartcardDevice(SmartcardDeviceProvider deviceProvider, ICardTerminal terminal) {
        super((CommonDeviceProvider)deviceProvider, "device" + counter++);
        this.setLabel(terminal.getName());
        this.cardTerminal = terminal;
        this.cardTerminal.addNotificationListener(CardEvent.ID, this.listenCardEvent);
        this.validator = new CertificatePeriodValidator();
        this.validator.setAddSubjectLabel(false);
    }

    public Object basicGetValue(String name) throws FieldException {
        if (PROP_CARD_SERIAL_NUMBER.equals(name)) {
            ICard tempCard = this.getCard();
            if (tempCard != null) {
                return tempCard.getAttribute((Object)name);
            }
        } else if (PROP_CARD_PRODUCT_ID.equals(name)) {
            ICardProduct product;
            ICard tempCard = this.getCard();
            if (tempCard != null && (product = CardProductTools.getCardProduct((ICard)tempCard)) != null) {
                return product.getId();
            }
        } else if (PROP_CARD_TERMINAL_IS_SPE.equals(name) || PROP_CARD_TERMINAL_STATE.equals(name)) {
            CardTerminalState cardTerminalState = this.getCardTerminalState();
            if (cardTerminalState == null) {
                return null;
            }
            if (PROP_CARD_TERMINAL_IS_SPE.equals(name)) {
                FeatureList featureList = cardTerminalState.getFeatureList();
                return featureList.getVerifyPinDirect() != 0 || featureList.getVerifyPinStart() != 0;
            }
            return cardTerminalState;
        }
        return super.basicGetValue(name);
    }

    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.validator = new CertificatePeriodValidator();
        this.validator.setAddSubjectLabel(false);
        IElement elPrincipalValidation = element.element(CFG_PRINCIPAL_VALIDATION);
        if (elPrincipalValidation != null) {
            Iterator itValidations = elPrincipalValidation.elementIterator();
            while (itValidations.hasNext()) {
                IElement validation = (IElement)itValidations.next();
                String name = validation.getName();
                String value = validation.attributeValue(EA_VALUE, null);
                String action = validation.attributeValue(EA_ACTION, EA_ACTION_DEFAULT);
                String debug = validation.attributeValue(EA_DEBUG, null);
                this.validator.setAction(name, (Object)value, action, debug);
            }
        }
        this.resetPrincipalSelector();
        this.resetCredentialSelector();
    }

    protected CredentialSelector createCredentialSelector() {
        IElement elSelector;
        CredentialSelector selector = new CredentialSelector(this);
        if (this.getConfiguration() != null && (elSelector = this.getConfiguration().element(CFG_CREDENTIAL_SELECTOR)) != null) {
            try {
                selector.configure(elSelector);
            }
            catch (ConfigurationException e) {
                Log.error(this.getLogPrefix() + " error configuring " + selector, (Throwable)e);
            }
            this.credentialSelectorAutostart = ElementTools.getBool((IElement)elSelector, (String)CFG_AUTOSTART, (boolean)this.credentialSelectorAutostart);
        }
        selector.addTaskCallback((ITaskCallback)new TaskCallbackAdapter<List<ICredential>>(){

            protected void onFinished(List<ICredential> result) {
                SmartcardDevice.this.setCredentials(result);
                if (!NoticeTools.hasError((INoticesSupport)SmartcardDevice.this)) {
                    IMessage msg = Msg.getMessage("SmartcardDevice.receivedCredentials", new Object[0]);
                    String code = NoticeTools.getActivityCode((String)AtomicState.OK.getId(), (String)"credentials");
                    SmartcardDevice.this.addNotice((INotice)new Notice(10, false, (IMessage)new AliasMessage(code, msg, new Object[0])));
                }
            }
        });
        return selector;
    }

    protected SmartcardPrincipal createIssuer(SmartcardPrincipal principal) {
        IX509PublicKeyCertificate certificate = principal.getX509PublicKeyCertificate();
        IX509Certificate[] path = ValidationTools.getCertificatePath((IX509Certificate)certificate, (boolean)true);
        SmartcardPrincipal current = principal;
        SmartcardPrincipal issuer = null;
        for (IX509Certificate cert : path) {
            SmartcardPrincipal tempPrincipal = this.createPrincipal((IX509PublicKeyCertificate)cert);
            if (tempPrincipal == principal) continue;
            if (issuer == null) {
                issuer = tempPrincipal;
            }
            current.setIssuer(tempPrincipal);
            current = tempPrincipal;
        }
        return issuer;
    }

    public SmartcardPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        SmartcardPrincipal principal = (SmartcardPrincipal)((Object)certificate.getAttribute((Object)ATTR_PRINCIPAL));
        if (principal == null) {
            principal = new SmartcardPrincipal(this, certificate);
            IValidationResult result = this.validator.validate((Object)certificate);
            for (INotice note : result.getNotices()) {
                principal.addNotice(note);
            }
            certificate.setAttribute((Object)ATTR_PRINCIPAL, (Object)principal);
        }
        return principal;
    }

    protected CommonPrincipalSelector createPrincipalSelector() {
        PrincipalSelectorAllCertificates selector;
        if (this.getConfiguration() == null) {
            selector = new PrincipalSelectorAllCertificates(this);
        } else {
            selector = new PrincipalSelectorAllCertificates(this);
            IElement elPrincipalSelector = this.getConfiguration().element(CFG_PRINCIPAL_SELECTOR);
            if (elPrincipalSelector != null) {
                this.principalSelectorAutostart = ElementTools.getBool((IElement)elPrincipalSelector, (String)CFG_AUTOSTART, (boolean)this.principalSelectorAutostart);
                try {
                    selector.configure(elPrincipalSelector);
                }
                catch (ConfigurationException e) {
                    Log.error(this.getLogPrefix() + " error configuring " + selector, (Throwable)e);
                }
            }
        }
        selector.addTaskCallback((ITaskCallback)new TaskCallbackAdapter<List<IPrincipal>>(){

            protected void onFinished(List<IPrincipal> result) {
                SmartcardDevice.this.setPrincipals(result);
                if (!NoticeTools.hasError((INoticesSupport)SmartcardDevice.this)) {
                    IMessage msg = Msg.getMessage("SmartcardDevice.receivedPrincipals", new Object[0]);
                    String code = NoticeTools.getActivityCode((String)AtomicState.OK.getId(), (String)"principals");
                    SmartcardDevice.this.addNotice((INotice)new Notice(10, false, (IMessage)new AliasMessage(code, msg, new Object[0])));
                }
            }
        });
        return selector;
    }

    protected void ensureCredentialsAvailable() {
        super.ensureCredentialsAvailable();
        try {
            if (!this.isCardValid()) {
                return;
            }
            CredentialSelector selector = this.getCredentialSelector();
            if (selector != null && !this.credentialSelectorAutostart) {
                selector.run();
            }
        }
        catch (Exception e) {
            Log.warn(this.getLogPrefix() + " error waiting for credentials ", (Throwable)e);
        }
    }

    protected void ensurePrincipalsAvailable() {
        super.ensurePrincipalsAvailable();
        try {
            if (!this.isCardValid()) {
                return;
            }
            CommonPrincipalSelector selector = this.getPrincipalSelector();
            if (selector != null && !this.principalSelectorAutostart) {
                Log.info("{} synch retrieve principals", (Object)this.getLogPrefix());
                selector.run();
                List tempPrincipals = (List)selector.get(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
                this.setPrincipals(tempPrincipals);
            }
        }
        catch (TimeoutException e) {
            Log.info("{} timeout waiting for principals", (Object)this.getLogPrefix());
        }
        catch (Exception e) {
            Log.warn("{} error waiting for principals", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    public void freeSecondaryResources() {
        this.getCardTerminal().freeSecondaryResources();
    }

    public ICard getCard() {
        ICardTerminal terminal = this.getCardTerminal();
        ICard card = terminal.getCard();
        if (card == null || card.getState().isInvalid()) {
            return null;
        }
        return card;
    }

    public ICardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    public CardTerminalState getCardTerminalState() {
        ICardTerminal terminal = this.getCardTerminal();
        CardTerminalState cardTerminalState = CardTerminalTools.getCardTerminalState((ICardTerminal)terminal);
        if (cardTerminalState == null) {
            this.requestCardTerminalState();
        }
        return cardTerminalState;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CredentialSelector getCredentialSelector() {
        Attribute attribute = this.attrCredentialSelector;
        synchronized (attribute) {
            ICard card = this.getCard();
            if (card == null) {
                return null;
            }
            CredentialSelector selector = (CredentialSelector)((Object)card.getAttribute((Object)this.attrCredentialSelector));
            if (selector == null) {
                selector = this.createCredentialSelector();
                card.setAttribute((Object)this.attrCredentialSelector, (Object)selector);
                if (this.credentialSelectorAutostart) {
                    selector.run();
                }
            }
            return selector;
        }
    }

    public String getLabel() {
        return this.cardTerminal.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommonPrincipalSelector getPrincipalSelector() {
        Attribute attribute = this.attrPrincipalSelector;
        synchronized (attribute) {
            ICard card = this.getCard();
            if (card == null) {
                return null;
            }
            CommonPrincipalSelector selector = (CommonPrincipalSelector)((Object)card.getAttribute((Object)this.attrPrincipalSelector));
            if (selector == null) {
                selector = this.createPrincipalSelector();
                card.setAttribute((Object)this.attrPrincipalSelector, (Object)selector);
                if (this.principalSelectorAutostart) {
                    Log.info("{} asynch retrieve principals", (Object)this.getLogPrefix());
                    selector.run();
                }
            }
            return selector;
        }
    }

    protected boolean isCardValid() {
        ICardTerminal terminal = this.getCardTerminal();
        if (terminal.getState().isInvalid()) {
            return false;
        }
        ICard card = terminal.getCard();
        return card != null && !card.getState().isInvalid();
    }

    protected void onCardEvent(CardEvent event) {
        this.updateDevice();
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)IDevice.ATTR_STATE, null, null));
    }

    public void renew() {
        this.clearNotices();
        this.resetPrincipalSelector();
        this.resetCredentialSelector();
        this.getCardTerminal().renew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCardTerminalState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.selector != null) {
                return;
            }
            Log.trace("{} create CardTerminalStateSelector", (Object)this.getLogPrefix());
            this.selector = new CardTerminalStateSelector(this);
            this.selector.addTaskCallback((ITaskCallback)new TaskCallbackAdapter<CardTerminalState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onFailed(TaskFailed exception) {
                    Object object = SmartcardDevice.this.lock;
                    synchronized (object) {
                        SmartcardDevice.this.selector = null;
                    }
                    SmartcardDevice.this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)SmartcardDevice.PROP_CARD_TERMINAL_STATE, null, null));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onFinished(CardTerminalState result) {
                    Object object = SmartcardDevice.this.lock;
                    synchronized (object) {
                        SmartcardDevice.this.selector = null;
                    }
                    SmartcardDevice.this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)SmartcardDevice.PROP_CARD_TERMINAL_STATE, null, (Object)result));
                }
            });
        }
        new Thread((Runnable)((Object)this.selector), this.selector.getLabel()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCredentialSelector() {
        Attribute attribute = this.attrCredentialSelector;
        synchronized (attribute) {
            ICard card = this.getCard();
            if (card != null) {
                Future selector = (Future)card.getAttribute((Object)this.attrCredentialSelector);
                if (selector != null) {
                    selector.cancel(true);
                }
                card.setAttribute((Object)this.attrCredentialSelector, null);
            }
        }
        this.setCredentials(new ArrayList(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetPrincipalSelector() {
        Attribute attribute = this.attrPrincipalSelector;
        synchronized (attribute) {
            ICard card = this.getCard();
            if (card != null) {
                Future selector = (Future)card.getAttribute((Object)this.attrPrincipalSelector);
                if (selector != null) {
                    selector.cancel(true);
                }
                card.setAttribute((Object)this.attrPrincipalSelector, null);
            }
        }
        this.setPrincipals(new ArrayList(0));
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Object setValue(String name, Object value) throws FieldException {
        ICard tempCard = this.getCard();
        if (tempCard != null && PROP_CARD_SERIAL_NUMBER.equals(name)) {
            return tempCard.setAttribute((Object)name, value);
        }
        return super.setValue(name, value);
    }

    protected void updateCredentials() {
        this.getCredentialSelector();
    }

    protected void updateDevice() {
        if (this.isCardValid()) {
            this.updatePrincipals();
            this.updateCredentials();
        } else {
            this.clearNotices();
            this.resetPrincipalSelector();
            this.resetCredentialSelector();
        }
    }

    protected void updatePrincipals() {
        this.getPrincipalSelector();
    }

    public <T extends ICardApplication, R> R withCardApplication(Class<T> clazz, IArgs args, String identifier, Function<T, R> function) throws Exception {
        ICardApplication app = (ICardApplication)ArgTools.getObject((IArgs)args, (String)ARG_CARD_APPLICATION, null);
        if (app != null) {
            return function.apply(app);
        }
        boolean localConnection = false;
        ICardConnection connection = (ICardConnection)ArgTools.getObject((IArgs)args, (String)ARG_CARD_CONNECTION, null);
        if (connection == null) {
            ICard card = this.getCard();
            if (card == null) {
                throw new ObjectCreationException("no card");
            }
            connection = CardTools.connectTransacted((ICard)card, (int)this.getConnectTimeout());
            localConnection = true;
        }
        try {
            ICardProduct product = CardProductTools.getCardProduct((ICardConnection)connection);
            Class cardApplication = ArgTools.getClass((IArgs)args, (String)ARG_CARD_APPLICATION_TYPE, clazz, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            app = product.createCardApplication(connection, cardApplication);
            if (app instanceof ICardHolderApplication) {
                ICardHolderCertificate signerCert = SmartcardDevice.getCertificate((ICardHolderApplication)app, args, identifier);
                ((ICardHolderApplication)app).setCardHolderCertificate(signerCert);
            }
            return function.apply(app);
        }
        catch (Exception e) {
            if (localConnection && connection != null) {
                try {
                    connection.close(1);
                }
                catch (CardException cardException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }
}

