/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.authentication.IAuthenticator;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.app.principal.IPrincipalReader;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.smartcard.app.authenticate.SmartcardAuthenticatorFactory;
import de.intarsys.security.device.smartcard.app.decrypt.SmartcardDecryptorFactory;
import de.intarsys.security.device.smartcard.app.management.SmartcardPrincipalReaderFactory;
import de.intarsys.security.device.smartcard.app.signature.SmartcardSignerFactory;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.smartcard.card.CardSystem;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.environment.SmartcardEnvironment;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartcardDeviceProvider
extends CommonDeviceProvider<SmartcardDevice> {
    private static final String CONF_DEFAULT = "default";
    private static final String ATTR_CARD_TERMINAL = "cardTerminal";
    private static final Logger Log = LoggerFactory.getLogger(SmartcardDeviceProvider.class);
    private final INotificationListener listenCardSystemChanged = new INotificationListener(){

        public void handleEvent(Event event) {
            SmartcardDeviceProvider.this.onCardSystemChanged((AttributeChangedEvent)event);
        }
    };
    private final CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);

    public SmartcardDeviceProvider() {
        super("smartcard");
    }

    protected void addNotificationDependencies() {
        super.addNotificationDependencies();
        ICardSystem cardSystem = CardSystem.get();
        cardSystem.addNotificationListener(AttributeChangedEvent.ID, this.listenCardSystemChanged);
    }

    protected SmartcardDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        Object terminalObject = args.get(ATTR_CARD_TERMINAL);
        if (terminalObject == null) {
            return null;
        }
        if (terminalObject instanceof ICardTerminal) {
            ICardTerminal terminal = (ICardTerminal)terminalObject;
            SmartcardDevice device = new SmartcardDevice(this, terminal);
            terminal.setAttribute((Object)this.attrDevice, (Object)device);
            try {
                IElement defaultElement;
                if (this.getConfiguration() != null && (defaultElement = this.getConfiguration().element(CONF_DEFAULT)) != null) {
                    device.configure(defaultElement);
                }
            }
            catch (ConfigurationException e) {
                Log.warn("configuration failed", (Throwable)e);
            }
            return device;
        }
        return null;
    }

    protected SmartcardDevice basicLookupInstance(IArgs args) throws ObjectCreationException {
        Object terminalObject = args.get(ATTR_CARD_TERMINAL);
        if (terminalObject == null) {
            return null;
        }
        if (terminalObject instanceof ICardTerminal) {
            ICardTerminal terminal = (ICardTerminal)terminalObject;
            return (SmartcardDevice)((Object)terminal.getAttribute((Object)this.attrDevice));
        }
        if (terminalObject instanceof String) {
            String terminalName = (String)terminalObject;
            Pattern terminalPattern = Pattern.compile(terminalName);
            Iterator it = this.listDevices(null);
            while (it.hasNext()) {
                SmartcardDevice device = (SmartcardDevice)((Object)it.next());
                if (!terminalPattern.matcher(device.getCardTerminal().getName()).matches()) continue;
                return device;
            }
        }
        return null;
    }

    public SmartcardDevice createInstance(ICardTerminal terminal) throws ObjectCreationException {
        Args args = Args.create();
        args.put(ATTR_CARD_TERMINAL, (Object)terminal);
        return (SmartcardDevice)this.createInstance((IArgs)args);
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        Object descriptor = new SmartcardSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        descriptor.setPolicy((IApplicationPolicy)this.signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new SmartcardAuthenticatorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IAuthenticator.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new SmartcardDecryptorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountDecrypt());
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IDecryptor.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new SmartcardPrincipalReaderFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IPrincipalReader.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected ILicenseAccount declareLicenseAccountDecryptBasic() {
        return this.getLicenseProduct().getAccount("de.intarsys.security.app.decrypt.account");
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.smartcard");
    }

    @PostConstruct
    public void init() {
        super.init();
        this.setAllowSecretFromAPI(ElementTools.getBool((IElement)this.getConfiguration(), (String)"allowSecretFromApi", (!SmartcardEnvironment.get().isEnforcePinEntry() ? 1 : 0) != 0));
        this.setAllowSecretFromCache(ElementTools.getBool((IElement)this.getConfiguration(), (String)"allowSecretFromCache", (boolean)SmartcardEnvironment.get().isEnablePinCache()));
        IElement policyElement = ElementTools.getPathElement((IElement)this.getConfiguration(), (String[])new String[]{"policies", "signer"});
        if (policyElement != null) {
            try {
                this.signerPolicy.configure(policyElement);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }

    protected void onCardSystemChanged(AttributeChangedEvent event) {
        try {
            SmartcardDevice oldDevice = this.createInstance((ICardTerminal)event.getOldValue());
            SmartcardDevice newDevice = this.createInstance((ICardTerminal)event.getNewValue());
            this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)this.ATTR_DEVICES, (Object)oldDevice, (Object)newDevice));
        }
        catch (ObjectCreationException objectCreationException) {
            // empty catch block
        }
    }

    protected void removeNotificationDependencies() {
        super.removeNotificationDependencies();
        ICardSystem cardSystem = CardSystem.get();
        cardSystem.removeNotificationListener(AttributeChangedEvent.ID, this.listenCardSystemChanged);
    }

    protected void updateDevices() {
        super.updateDevices();
        this.basicClearDevices();
        ICardSystem cardSystem = CardSystem.get();
        ICardTerminal[] terminals = cardSystem.getCardTerminals();
        for (int i = 0; i < terminals.length; ++i) {
            try {
                this.basicRegisterDevice(this.createInstance(terminals[i]));
                continue;
            }
            catch (ObjectCreationException e) {
                Log.warn("can't create smartcard device", (Throwable)e);
            }
        }
    }
}

