/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.principal.IPrincipalReader;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDeviceProvider;
import de.intarsys.security.environment.SecurityEnvironment;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.tools.activity.RequestPassword;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectHolder;
import java.util.Iterator;

public final class SmartcardDeviceTools {
    public static final String TYPE_NO_PRINCIPALS = "NoPrincipals";
    public static final String TYPE_FAILED = "Failed";
    public static final String TYPE_AUTHENTICATION_FAILED = "AuthenticationFailed";
    public static final String TYPE_AUTHENTICATION_SUCCESS = "AuthenticationSuccess";
    public static final String TYPE_AUTHENTICATE = "Authenticate";
    public static final String TYPE_DEVICE_FOUND = "DeviceFound";
    public static final String TYPE_READY = "Ready";
    public static final String TYPE_DEVICE_NOT_FOUND = "DeviceNotFound";

    public static void cachePins(ICardConnection connection, IX509CertificateFilter filter, INotificationListener<Notification> listener) {
        try {
            SmartcardDevice smartcardDevice = SmartcardDeviceTools.lookupDevice(connection);
            if (smartcardDevice == null) {
                SmartcardDeviceTools.trigger(listener, TYPE_DEVICE_NOT_FOUND);
                return;
            }
            SmartcardDeviceTools.trigger(listener, TYPE_DEVICE_FOUND);
            Args argsPrincipalReader = Args.create();
            argsPrincipalReader.put("cardConnection", (Object)connection);
            IPrincipalReader appPrincipalReader = (IPrincipalReader)smartcardDevice.createApplication(IPrincipalReader.class.getName(), (IArgs)argsPrincipalReader);
            Iterator itPrincipals = appPrincipalReader.loadPrincipals();
            boolean principalFound = false;
            while (itPrincipals.hasNext()) {
                IPrincipal principal = (IPrincipal)itPrincipals.next();
                if (!(principal instanceof IX509Principal) || !((IX509Principal)principal).isKeyOwner()) continue;
                IX509PublicKeyCertificate cert = ((IX509Principal)principal).getX509PublicKeyCertificate();
                if (filter != null && !filter.accept((IX509Certificate)cert)) continue;
                principalFound = true;
                String id = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)cert);
                try {
                    ObjectHolder secretHolder = new ObjectHolder();
                    RequestPassword.PasswordProvider pp = new RequestPassword.PasswordProvider((IValueHolder)secretHolder){
                        final /* synthetic */ IValueHolder val$secretHolder;
                        {
                            this.val$secretHolder = iValueHolder;
                        }

                        public Secret getPassword() {
                            Secret secret = super.getPassword();
                            this.val$secretHolder.set((Object)secret);
                            return secret;
                        }
                    };
                    Args argsSigner = Args.create();
                    argsSigner.put("cardConnection", (Object)connection);
                    argsSigner.put("signerIdentifier", (Object)principal);
                    argsSigner.put("passwordProvider", (Object)pp);
                    ISigner appSigner = (ISigner)smartcardDevice.createApplication(ISigner.class.getName(), (IArgs)argsSigner);
                    ((IAuthenticatedApplication)appSigner).setAuthenticationPin(null);
                    SmartcardDeviceTools.trigger(listener, TYPE_AUTHENTICATE);
                    ((IAuthenticatedApplication)appSigner).authenticate().get();
                    if (!CryptoTools.isEmpty((Secret)((Secret)secretHolder.get()))) {
                        SecurityEnvironment.get().setSecret(id, (Secret)secretHolder.get(), true);
                    } else {
                        SecurityEnvironment.get().clearSecret(id);
                    }
                    SmartcardDeviceTools.trigger(listener, TYPE_AUTHENTICATION_SUCCESS);
                }
                catch (Exception e) {
                    Throwable unwrap = ExceptionTools.unwrap((Throwable)e);
                    if (unwrap instanceof AuthenticationFailed) {
                        AuthenticationFailed af = (AuthenticationFailed)unwrap;
                        SecurityEnvironment.get().clearSecret(id);
                    }
                    SmartcardDeviceTools.trigger(listener, TYPE_AUTHENTICATION_FAILED);
                }
            }
            if (!principalFound) {
                SmartcardDeviceTools.trigger(listener, TYPE_NO_PRINCIPALS);
            }
            SmartcardDeviceTools.trigger(listener, TYPE_READY);
        }
        catch (Exception e) {
            SmartcardDeviceTools.trigger(listener, TYPE_FAILED);
        }
    }

    public static SmartcardDevice lookupDevice(ICard card) {
        SmartcardDeviceProvider provider = (SmartcardDeviceProvider)((Object)DeviceTools.lookupDeviceProvider(SmartcardDeviceProvider.class));
        try {
            return provider.createInstance(card.getCardTerminal());
        }
        catch (ObjectCreationException e) {
            throw new IllegalStateException("cannot create device for terminal " + card.getCardTerminal());
        }
    }

    public static SmartcardDevice lookupDevice(ICardConnection connection) {
        return SmartcardDeviceTools.lookupDevice(connection.getCard());
    }

    protected static void trigger(INotificationListener<Notification> listener, String string) {
        if (listener != null) {
            listener.handleEvent((Event)new Notification(SmartcardDeviceTools.class, string));
        }
    }

    private SmartcardDeviceTools() {
    }

    public static class Notification
    extends Event {
        public static final EventType ID = new EventType(Notification.class.getName());
        private static final long serialVersionUID = 1L;
        private final String type;

        public Notification(Object source, String type) {
            super(source);
            this.type = type;
        }

        public EventType getEventType() {
            return ID;
        }

        public String getType() {
            return this.type;
        }
    }
}

