/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.smartcard.device;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.common.CommonX509Principal;
import de.intarsys.security.device.smartcard.device.SmartcardDevice;
import de.intarsys.security.device.smartcard.device.SmartcardDeviceProvider;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.app.common.IDecryptApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardApplicationInfo;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardPublicKeyCertificate;
import de.intarsys.security.smartcard.model.app.CardApplicationBinding;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public class SmartcardPrincipal
extends CommonX509Principal {
    private boolean keyOwner = false;
    private final ICardPublicKeyCertificate cardCertificate;

    protected SmartcardPrincipal(SmartcardDevice device, IX509PublicKeyCertificate certificate) {
        super((IDevice)device, certificate, certificate.getSerialNumber().toString());
        assert (device instanceof SmartcardDevice);
        if (certificate instanceof ICardHolderCertificate) {
            this.setKeyOwner(true);
            this.setAllowSecretFromCache(((SmartcardDeviceProvider)device.getDeviceProvider()).isAllowSecretFromCache());
            this.cardCertificate = (ICardHolderCertificate)certificate;
        } else if (certificate instanceof ICardPublicKeyCertificate) {
            this.setKeyOwner(false);
            this.cardCertificate = (ICardPublicKeyCertificate)certificate;
        } else {
            this.setKeyOwner(false);
            this.cardCertificate = null;
        }
    }

    protected CommonX509Principal createIssuer() {
        return this.getDevice().createIssuer(this);
    }

    protected ICard getCard() {
        if (this.cardCertificate == null) {
            return null;
        }
        return this.cardCertificate.getCard();
    }

    public ICardPublicKeyCertificate getCardCertificate() {
        return this.cardCertificate;
    }

    public SmartcardDevice getDevice() {
        return (SmartcardDevice)super.getDevice();
    }

    public X509Certificate getJavaCertificate() {
        try {
            return this.getX509PublicKeyCertificate().toJavaCertificate();
        }
        catch (CertificateException e) {
            return null;
        }
    }

    public boolean isKeyOwner() {
        return this.keyOwner;
    }

    protected void setIssuer(CommonX509Principal issuer) {
        super.setIssuer(issuer);
    }

    protected void setKeyOwner(boolean keyOwner) {
        this.keyOwner = keyOwner;
    }

    public boolean supportsApplication(ICardProduct product, Class<? extends ICardApplication> appType, ICardHolderCertificate cert) {
        ICardApplicationInfo cardApplicationInfo = product.getCardInfo().lookupCardApplicationInfo(appType);
        if (cardApplicationInfo == null) {
            return false;
        }
        List bindings = cardApplicationInfo.getBindings();
        for (CardApplicationBinding binding : bindings) {
            if (binding.getCardHolderCertificateInfo() != cert.getInfo()) continue;
            return true;
        }
        return false;
    }

    public boolean supportsApplication(String id) {
        if (!(this.getCardCertificate() instanceof ICardHolderCertificate)) {
            return false;
        }
        ICardProduct product = CardProductTools.getCardProduct((ICard)this.getCard());
        if ("Signature".equals(id)) {
            Class<ISignApplication> appType = ISignApplication.class;
            ICardHolderCertificate cert = (ICardHolderCertificate)this.getCardCertificate();
            return this.supportsApplication(product, appType, cert);
        }
        if ("Authentication".equals(id)) {
            Class<IAuthenticateApplication> appType = IAuthenticateApplication.class;
            ICardHolderCertificate cert = (ICardHolderCertificate)this.getCardCertificate();
            return this.supportsApplication(product, appType, cert);
        }
        if ("Encryption".equals(id)) {
            Class<IDecryptApplication> appType = IDecryptApplication.class;
            ICardHolderCertificate cert = (ICardHolderCertificate)this.getCardCertificate();
            return this.supportsApplication(product, appType, cert);
        }
        return false;
    }
}

