/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl;

import de.intarsys.security.tl.ITrustedListManager;
import de.intarsys.security.tl.ITrustedListUpdater;
import de.intarsys.security.tl.manager.EagerInitializableTrustedListManager;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.concurrent.EagerInitializer;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public class TrustedListInstaller
implements IElementConfigurable {
    private IElement config;
    private EagerInitializableTrustedListManager trustedListManager;
    private ITrustedListUpdater trustedListUpdater;

    public void configure(IElement element) throws ConfigurationException {
        this.config = element;
    }

    protected void createTrustedListManager() {
        this.trustedListManager = new EagerInitializableTrustedListManager(this.getConfig().element("tlmanager"));
        ServiceLocator.get().put(ITrustedListManager.class, (Object)this.trustedListManager);
    }

    protected void createTrustedListUpdater() {
        this.trustedListUpdater = new ITrustedListUpdater(){

            @Override
            public void update(IProgressMonitor progressMonitor) throws IOException {
                ITrustedListUpdater impl = (ITrustedListUpdater)AdapterTools.getAdapter((Object)TrustedListInstaller.this.trustedListManager.getImpl(), ITrustedListUpdater.class, null);
                if (impl == null) {
                    throw new IOException("Update not supported.");
                }
                impl.update(progressMonitor);
            }
        };
        ServiceLocator.get().put(ITrustedListUpdater.class, (Object)this.trustedListUpdater);
    }

    protected IElement getConfig() {
        return this.config;
    }

    @PostConstruct
    public void init() {
        this.createTrustedListManager();
        this.createTrustedListUpdater();
        this.trustedListManager.initialize((ExecutorService)EagerInitializer.get());
    }
}

