/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl;

import de.intarsys.security.certificate.common.EmptyCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListManager;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.servicelocator.ServiceNotFoundException;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonProvider
public class TrustedListManager {
    private static final ITrustedListManager EMPTY_LIST = new EmptyTrustedListManager();
    private static final Logger Log = LoggerFactory.getLogger(TrustedListManager.class);

    public static ITrustedListManager get() {
        try {
            return (ITrustedListManager)ServiceLocator.get().get(ITrustedListManager.class);
        }
        catch (ServiceNotFoundException e) {
            Log.warn("No Trusted List manager installed, falling back to empty list.");
            return EMPTY_LIST;
        }
    }

    private static class EmptyTrustedListManager
    implements ITrustedListManager {
        private EmptyTrustedListManager() {
        }

        @Override
        public ICertificateProvider getCertificateProvider() {
            return EmptyCertificateProvider.INSTANCE;
        }

        @Override
        public Iterator<ITrustedList> lookupTrustedLists() {
            return Collections.emptyIterator();
        }
    }
}

