/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProviderSupport;
import de.intarsys.security.tl.ITSPService;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.jaxb.JAXBTools;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.etsi.uri._02231.v2.InternationalNamesType;
import org.etsi.uri._02231.v2.MultiLangNormStringType;
import org.etsi.uri._02231.v2.TrustStatusListType;

public class LanguageTools {
    private static final String DEFAULT_LANGUAGE = "en";

    public static String getLocal(InternationalNamesType internationalNames) {
        return LanguageTools.getLocal(internationalNames, Locale.getDefault().getLanguage());
    }

    public static String getLocal(InternationalNamesType internationalNames, String language) {
        if (internationalNames == null) {
            return null;
        }
        String defaultValue = null;
        List names = internationalNames.getName();
        for (MultiLangNormStringType name : names) {
            if (language.equals(name.getLang())) {
                return name.getValue();
            }
            if (!DEFAULT_LANGUAGE.equals(name.getLang())) continue;
            defaultValue = name.getValue();
        }
        return defaultValue;
    }

    public static ITSPService getService(IX509Certificate certificate) {
        if (certificate instanceof ICertificateProviderSupport) {
            ICertificateProvider certificateProvider = certificate.getCertificateProvider();
            return (ITSPService)AdapterTools.getAdapter((Object)certificateProvider, ITSPService.class, null);
        }
        return null;
    }

    public static TrustStatusListType parseTrustStatusList(ILocator locator) throws IOException {
        return (TrustStatusListType)JAXBTools.unmarshalElement((ILocator)locator, TrustStatusListType.class);
    }

    public static TrustStatusListType parseTrustStatusList(InputStream is) throws IOException {
        return (TrustStatusListType)JAXBTools.unmarshalElement((InputStream)is, TrustStatusListType.class);
    }

    private LanguageTools() {
    }
}

