/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.tl.impl.Extension;
import de.intarsys.security.tl.impl.QualifierId;
import de.intarsys.tools.jaxb.JAXBTools;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.etsi.uri._02231.v2.ExtensionType;
import org.etsi.uri._02231.v2.sie.QualificationsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QualificationsExtension
extends Extension {
    private static final Logger Log = LoggerFactory.getLogger(QualificationsExtension.class);
    private QualificationsType impl;

    public static Optional<QualificationsExtension> create(ExtensionType extensionType) {
        List content = extensionType.getContent();
        if (content == null) {
            return null;
        }
        Stream<Element> elements = content.stream().filter(o -> Element.class.isInstance(o)).map(o -> (Element)Element.class.cast(o)).filter(el -> el.getNodeName().indexOf("Qualifications") > -1);
        Optional<Element> element = elements.findFirst();
        if (!element.isPresent()) {
            return Optional.empty();
        }
        try {
            Unmarshaller unmarshaller = JAXBTools.getUnmarshaller(QualificationsType.class);
            JAXBElement jaxbElement = unmarshaller.unmarshal((Node)element.get(), QualificationsType.class);
            return Optional.of(new QualificationsExtension(extensionType, (QualificationsType)jaxbElement.getValue()));
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public QualificationsExtension(ExtensionType extension, QualificationsType impl) {
        super(extension);
        this.impl = impl;
    }

    public QualificationsType getImpl() {
        return this.impl;
    }

    public List<QualifierId> getQualifiers() {
        List qualificationElements = this.getImpl().getQualificationElement();
        return qualificationElements.stream().flatMap(e -> e.getQualifiers().getQualifier().stream()).map(q -> QualifierId.ofUri(q.getUri())).collect(Collectors.toList());
    }
}

