/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.common.CommonX509Certificate;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.tl.IDigitalIdentitySupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.etsi.uri._02231.v2.AnyType;
import org.etsi.uri._02231.v2.DigitalIdentityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.KeyValueType;

public class ServiceDigitalIdentities
implements IDigitalIdentitySupport {
    private static final Logger Log = LoggerFactory.getLogger(ServiceDigitalIdentities.class);
    private List<IX509PublicKeyCertificate> certificates;
    private PublicKey publicKey;
    private X500Principal subject;
    private byte[] subjectKeyIdentifier;
    private final List<DigitalIdentityType> digitalIdentities;
    private final Object context;
    private boolean initializedDigitalIds;

    public ServiceDigitalIdentities(List<DigitalIdentityType> digitalIdentities, Object context) {
        this.digitalIdentities = digitalIdentities;
        this.context = context;
    }

    @Override
    public List<IX509PublicKeyCertificate> getCertificates() {
        this.initDigitalIds();
        return new ArrayList<IX509PublicKeyCertificate>(this.certificates);
    }

    @Override
    public PublicKey getPublicKey() {
        this.initDigitalIds();
        return this.publicKey;
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        this.initDigitalIds();
        return this.subjectKeyIdentifier;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        this.initDigitalIds();
        return this.subject;
    }

    protected synchronized void initDigitalIds() {
        if (this.initializedDigitalIds) {
            return;
        }
        this.initializedDigitalIds = true;
        this.certificates = new ArrayList<IX509PublicKeyCertificate>();
        for (DigitalIdentityType digitalId : new ArrayList<DigitalIdentityType>(this.digitalIdentities)) {
            this.readDigitalId(digitalId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readDigitalId(DigitalIdentityType digitalId) {
        byte[] bCertificate = digitalId.getX509Certificate();
        if (bCertificate == null) {
            byte[] x509ski = digitalId.getX509SKI();
            if (x509ski == null) {
                String x509SubjectName = digitalId.getX509SubjectName();
                if (x509SubjectName == null) {
                    KeyValueType keyValue = digitalId.getKeyValue();
                    if (keyValue == null) {
                        AnyType other = digitalId.getOther();
                        if (other == null) return;
                    }
                    this.publicKey = null;
                    return;
                } else {
                    try {
                        this.subject = CertificateTools.parsePrincipal((String)x509SubjectName);
                        return;
                    }
                    catch (Exception e) {
                        Log.trace("Error parsing service digital id. Cannot parse '{}' ({})", (Object)x509SubjectName, (Object)e.getMessage());
                    }
                }
                return;
            } else {
                this.subjectKeyIdentifier = x509ski;
            }
            return;
        }
        try {
            IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)X509CertificateFactory.get().createCertificate((InputStream)new ByteArrayInputStream(bCertificate));
            if (certificate instanceof CommonX509Certificate && this.context instanceof ICertificateProvider) {
                ((CommonX509Certificate)certificate).setCertificateProvider((ICertificateProvider)this.context);
            }
            this.certificates.add(certificate);
            return;
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }
}

