/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.certificate.IServiceType;
import de.intarsys.security.certificate.ITrustService;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.ServiceTypes;
import de.intarsys.security.certificate.TrustServiceTools;
import de.intarsys.security.certificate.common.SimpleServiceType;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.tl.CHServiceTypes;
import de.intarsys.security.tl.ETSIServiceTypes;
import de.intarsys.security.tl.IServiceStatus;
import de.intarsys.security.tl.ITSPService;
import de.intarsys.security.tl.ITrustServiceProvider;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.impl.LanguageTools;
import de.intarsys.security.tl.impl.QualifierId;
import de.intarsys.security.tl.impl.ServiceDigitalIdentities;
import de.intarsys.security.tl.impl.ServiceInformationExtensions;
import de.intarsys.security.tl.impl.ServiceStatus;
import de.intarsys.security.tl.impl.TrustedListManagerTools;
import de.intarsys.security.validation.QCType;
import de.intarsys.tools.presentation.IPresentationSupport;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.etsi.uri._02231.v2.ExtensionsListType;
import org.etsi.uri._02231.v2.TSPServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSPService
implements ITSPService,
ICertificateProvider,
IPresentationSupport {
    private static final Logger Log = LoggerFactory.getLogger(TSPService.class);
    private final TSPServiceType impl;
    private final ITrustServiceProvider provider;
    private ServiceDigitalIdentities digitalIdentities;
    private ITrustService trustServiceHandle = new TrustServiceHandle();

    public TSPService(TSPServiceType impl, ITrustServiceProvider provider) {
        this.impl = impl;
        this.provider = provider;
    }

    protected boolean accept(IX509CertificateFilter filter) {
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null && selector.hasPrivateKey().booleanValue()) {
                return false;
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null) {
                if (!serviceTypeSelector.isTrustedOnly()) {
                    return false;
                }
                IServiceType serviceType = this.getType();
                if (serviceType == null) {
                    return true;
                }
                for (IServiceType requestedType : serviceTypeSelector.getServiceTypes()) {
                    if (serviceType.equals(requestedType)) {
                        return true;
                    }
                    switch (requestedType.getUri()) {
                        case "http://uri.intarsys.de/TrstSvc/Svctype/trusted": {
                            return true;
                        }
                        case "http://uri.intarsys.de/TrstSvc/Svctype/trustedlist": {
                            if (!serviceType.equals(ETSIServiceTypes.ST_TLIssuer)) break;
                            return true;
                        }
                        case "http://uri.intarsys.de/TrstSvc/Svctype/qualifiedsignature": {
                            if (serviceType.equals(ETSIServiceTypes.ST_CA_QC)) {
                                return true;
                            }
                            if (serviceType.equals(ETSIServiceTypes.ST_NationalRootCA_QC)) {
                                return true;
                            }
                            if (!serviceType.equals(CHServiceTypes.ST_CA_QC)) break;
                            return true;
                        }
                        case "http://uri.intarsys.de/TrstSvc/Svctype/qualifiedtimestamp": {
                            if (serviceType.equals(ETSIServiceTypes.ST_TSA_QTST)) {
                                return true;
                            }
                            if (!serviceType.equals(CHServiceTypes.ST_TSA_QTST)) break;
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        return true;
    }

    public boolean containsCertificate(IX509Certificate certificate) {
        try {
            return this.getCertificates().contains(certificate);
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<IX509PublicKeyCertificate> getCertificates() {
        return this.getDigitalIdentities().getCertificates().stream().map(cert -> {
            TrustServiceTools.setTrustService((IX509Certificate)cert, (ITrustService)this.getTrustService());
            return cert;
        }).collect(Collectors.toList());
    }

    public String getDescription() {
        return this.getLabel();
    }

    protected ServiceDigitalIdentities getDigitalIdentities() {
        if (this.digitalIdentities == null) {
            this.digitalIdentities = new ServiceDigitalIdentities(this.getImpl().getServiceInformation().getServiceDigitalIdentity().getDigitalId(), this);
        }
        return this.digitalIdentities;
    }

    public String getIconName() {
        return null;
    }

    @Override
    public TSPServiceType getImpl() {
        return this.impl;
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        return LanguageTools.getLocal(this.getImpl().getServiceInformation().getServiceName());
    }

    @Override
    public ITrustServiceProvider getProvider() {
        return this.provider;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.getDigitalIdentities().getPublicKey();
    }

    protected Optional<ServiceInformationExtensions> getServiceInformationExtensions() {
        return Optional.ofNullable(this.getImpl().getServiceInformation().getServiceInformationExtensions()).map(e -> new ServiceInformationExtensions((ExtensionsListType)e));
    }

    @Override
    public IServiceStatus getStatus() {
        String uri = this.getImpl().getServiceInformation().getServiceStatus();
        Date startDate = this.getImpl().getServiceInformation().getStatusStartingTime().toGregorianCalendar().getTime();
        return new ServiceStatus(uri, startDate);
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        return this.getDigitalIdentities().getSubjectKeyIdentifier();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.getDigitalIdentities().getSubjectX500Principal();
    }

    public String getTip() {
        return this.getDescription();
    }

    protected synchronized ITrustService getTrustService() {
        return this.trustServiceHandle;
    }

    @Override
    public IServiceType getType() {
        String uri = this.getImpl().getServiceInformation().getServiceTypeIdentifier();
        IServiceType serviceType = ServiceTypes.lookupServiceType((String)uri);
        if (serviceType == null) {
            serviceType = new SimpleServiceType(uri, false, false, true);
        }
        return serviceType;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        try {
            if (!this.accept(filter)) {
                return Collections.emptyIterator();
            }
            return this.getCertificates().stream().filter(filter).map(cert -> cert).iterator();
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }

    public String toString() {
        return "TSPService " + this.getName();
    }

    private class TrustServiceHandle
    implements ITrustService {
        private List<QCType> qcTypes;
        private List<QualifierId> qualifiers;
        private List<String> territories;

        protected List<String> collectTerritories() {
            ITrustedList trustedList = TSPService.this.provider.getTrustedList();
            return TrustedListManagerTools.getTerritories(trustedList);
        }

        public synchronized List<QCType> getQcTypes() {
            if (this.qcTypes == null) {
                this.qcTypes = new ArrayList<QCType>();
                Optional<ServiceInformationExtensions> serviceInformationExtensions = TSPService.this.getServiceInformationExtensions();
                Stream additionalServiceInformationExtensions = serviceInformationExtensions.map(s -> s.getAdditionalServiceInformation()).orElseGet(() -> Stream.empty());
                additionalServiceInformationExtensions.map(ext -> ext.getAdditionalServiceInformationTypeId()).forEach(id -> {
                    switch (id) {
                        case ForeSignatures: {
                            this.qcTypes.add(QCType.esign);
                            break;
                        }
                        case ForeSeals: {
                            this.qcTypes.add(QCType.eseal);
                            break;
                        }
                        case ForWebSiteAuthentication: {
                            this.qcTypes.add(QCType.web);
                            break;
                        }
                    }
                });
            }
            return this.qcTypes;
        }

        protected synchronized List<QualifierId> getQualifiers() {
            if (this.qualifiers == null) {
                Optional<ServiceInformationExtensions> serviceInformationExtensions = TSPService.this.getServiceInformationExtensions();
                Stream qualificationsExtensions = serviceInformationExtensions.map(s -> s.getQualifications()).orElseGet(() -> Stream.empty());
                this.qualifiers = qualificationsExtensions.flatMap(e -> e.getQualifiers().stream()).collect(Collectors.toList());
            }
            return this.qualifiers;
        }

        public List<String> getTerritories() {
            if (this.territories == null) {
                this.territories = this.collectTerritories();
            }
            return this.territories;
        }

        public boolean isQcCompliant() {
            return false;
        }

        public boolean isStoredOnQSCD() {
            return this.getQualifiers().contains((Object)QualifierId.QCWithQSCD) || this.getQualifiers().contains((Object)QualifierId.QCWithSSCD) || this.getQualifiers().contains((Object)QualifierId.QCQSCDManagedOnBehalf);
        }
    }
}

