/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.tl.ITSPService;
import de.intarsys.security.tl.ITSPServiceSelector;
import de.intarsys.security.tl.ITrustServiceProvider;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.impl.LanguageTools;
import de.intarsys.security.tl.impl.TSPService;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.etsi.uri._02231.v2.TSPServiceType;
import org.etsi.uri._02231.v2.TSPServicesListType;
import org.etsi.uri._02231.v2.TSPType;

public class TrustServiceProvider
implements ITrustServiceProvider,
ICertificateProvider {
    private final TSPType impl;
    private final ITrustedList trustedList;
    private List<ITSPService> services;
    private ICertificateProvider certificateProvider;

    public TrustServiceProvider(TSPType impl, ITrustedList trustedList) {
        this.impl = impl;
        this.trustedList = trustedList;
    }

    protected List<ITSPService> basicGetServices() {
        TSPServicesListType tspServicesList = this.getImpl().getTSPServices();
        if (tspServicesList == null) {
            return Collections.emptyList();
        }
        return tspServicesList.getTSPService().stream().map(service -> new TSPService((TSPServiceType)service, this)).collect(Collectors.toList());
    }

    public boolean containsCertificate(IX509Certificate certificate) {
        return this.getCertificateProvider().containsCertificate(certificate);
    }

    protected synchronized ICertificateProvider getCertificateProvider() {
        if (this.certificateProvider == null) {
            CompositeCertificateProvider certificateProvider = new CompositeCertificateProvider("trustService-" + this.getName());
            for (ITSPService service : this.getServices()) {
                certificateProvider.registerCertificateProvider((ICertificateProvider)service);
            }
            this.certificateProvider = certificateProvider;
        }
        return this.certificateProvider;
    }

    @Override
    public TSPType getImpl() {
        return this.impl;
    }

    @Override
    public String getName() {
        return LanguageTools.getLocal(this.getImpl().getTSPInformation().getTSPName());
    }

    @Override
    public List<ITSPService> getServices() {
        if (this.services == null) {
            this.services = this.basicGetServices();
        }
        return this.services;
    }

    @Override
    public String getTradeName() {
        return LanguageTools.getLocal(this.getImpl().getTSPInformation().getTSPTradeName());
    }

    @Override
    public ITrustedList getTrustedList() {
        return this.trustedList;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        return this.getCertificateProvider().lookupCertificates(filter);
    }

    @Override
    public Stream<ITSPService> lookupServices(ITSPServiceSelector selector) {
        return this.getServices().stream().filter(selector);
    }

    public String toString() {
        return "TrustServiceProvider " + this.getName();
    }
}

