/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.certificate.IServiceType;
import de.intarsys.security.certificate.ITrustBase;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.TrustBaseTools;
import de.intarsys.security.certificate.common.EmptyCertificateProvider;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.method.xml.signature.XMLSignatureContainer;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.tl.CHServiceTypes;
import de.intarsys.security.tl.ETSIServiceTypes;
import de.intarsys.security.tl.ITSPService;
import de.intarsys.security.tl.ITSPServiceSelector;
import de.intarsys.security.tl.ITrustServiceProvider;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.impl.LanguageTools;
import de.intarsys.security.tl.impl.PACKAGE;
import de.intarsys.security.tl.impl.TSPServiceSelector;
import de.intarsys.security.tl.impl.TrustServiceProvider;
import de.intarsys.security.tl.impl.TrustedListPointer;
import de.intarsys.security.tl.impl.TrustedListTools;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.etsi.uri._02231.v2.NextUpdateType;
import org.etsi.uri._02231.v2.OtherTSLPointerType;
import org.etsi.uri._02231.v2.OtherTSLPointersType;
import org.etsi.uri._02231.v2.TSPType;
import org.etsi.uri._02231.v2.TrustServiceProviderListType;
import org.etsi.uri._02231.v2.TrustStatusListType;

public class TrustedList
implements ITrustedList,
ILocatorSupport,
ICertificateProvider,
IAttributeSupport {
    private final IMessageBundle Msg = PACKAGE.Messages;
    private final TrustStatusListType impl;
    private final ILocator locator;
    private ICertificateProvider servicesCertificateProvider;
    private ICertificateProvider pointersCertificateProvider;
    private List<ITrustedListPointer> tslPointers;
    private List<ITrustServiceProvider> providers;
    private final AttributeMap attributes = new AttributeMap();
    private final ITrustBase trustBase = new ITrustBase(){

        public String getLabel() {
            return TrustedList.this.getLabel();
        }

        public String getType() {
            return "";
        }
    };

    public static TrustedList create(ILocator locator) throws IOException {
        TrustStatusListType trustStatusList = TrustedListTools.parseTrustStatusList(locator);
        return new TrustedList(trustStatusList, locator);
    }

    protected static ICertificateProvider getCertificateProvider(ITSPService service) {
        ICertificateProvider certificateProvider = (ICertificateProvider)AdapterTools.getAdapter((Object)service, ICertificateProvider.class, null);
        if (certificateProvider == null) {
            certificateProvider = EmptyCertificateProvider.INSTANCE;
        }
        return certificateProvider;
    }

    protected TrustedList(TrustStatusListType impl, ILocator locator) {
        this.impl = impl;
        this.locator = locator;
    }

    protected List<ITrustServiceProvider> basicGetProviders() {
        ArrayList<ITrustServiceProvider> result = new ArrayList<ITrustServiceProvider>();
        TrustServiceProviderListType trustServiceProviderList = this.getImpl().getTrustServiceProviderList();
        if (trustServiceProviderList != null) {
            for (TSPType trustServiceProvider : trustServiceProviderList.getTrustServiceProvider()) {
                result.add(new TrustServiceProvider(trustServiceProvider, this));
            }
        }
        return result;
    }

    protected List<ITrustedListPointer> basicGetTSLPointers() {
        OtherTSLPointersType pointersToOtherTSL = this.getImpl().getSchemeInformation().getPointersToOtherTSL();
        if (pointersToOtherTSL == null) {
            return Collections.emptyList();
        }
        ArrayList<ITrustedListPointer> result = new ArrayList<ITrustedListPointer>();
        List tslPointers = pointersToOtherTSL.getOtherTSLPointer();
        for (OtherTSLPointerType tslPointer : tslPointers) {
            TrustedListPointer pointer = new TrustedListPointer(tslPointer, this);
            result.add(pointer);
        }
        return result;
    }

    public boolean containsCertificate(IX509Certificate certificate) {
        return this.getCompleteCertificateProvider().containsCertificate(certificate);
    }

    protected ICertificateProvider createCertificateProvider(IServiceType serviceType) {
        TSPServiceSelector serviceSelector = new TSPServiceSelector();
        switch (serviceType.getUri()) {
            case "http://uri.intarsys.de/TrstSvc/Svctype/trusted": {
                return this.getCompleteCertificateProvider();
            }
            case "http://uri.intarsys.de/TrstSvc/Svctype/trustedlist": 
            case "http://uri.etsi.org/TrstSvc/Svctype/TLIssuer": {
                return this.getPointersCertificateProvider();
            }
            case "http://uri.intarsys.de/TrstSvc/Svctype/qualifiedsignature": {
                serviceSelector.addAcceptableTrustService(ETSIServiceTypes.ST_CA_QC);
                serviceSelector.addAcceptableTrustService(ETSIServiceTypes.ST_NationalRootCA_QC);
                serviceSelector.addAcceptableTrustService(CHServiceTypes.ST_CA_QC);
                break;
            }
            case "http://uri.intarsys.de/TrstSvc/Svctype/qualifiedtimestamp": {
                serviceSelector.addAcceptableTrustService(ETSIServiceTypes.ST_TSA_QTST);
                serviceSelector.addAcceptableTrustService(CHServiceTypes.ST_TSA_QTST);
                break;
            }
            default: {
                serviceSelector.addAcceptableTrustService(serviceType);
            }
        }
        Stream<ITSPService> candidateServices = this.lookupServices(serviceSelector);
        return new ServicesCertificateProvider(candidateServices);
    }

    protected ICertificateProvider createCertificateProvider(IX509CertificateFilter filter) {
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null && selector.hasPrivateKey().booleanValue()) {
                return EmptyCertificateProvider.INSTANCE;
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null) {
                if (!serviceTypeSelector.isTrustedOnly()) {
                    return EmptyCertificateProvider.INSTANCE;
                }
                Set serviceTypes = serviceTypeSelector.getServiceTypes();
                if (serviceTypes.isEmpty()) {
                    return this.getCompleteCertificateProvider();
                }
                ICertificateProvider result = null;
                for (IServiceType serviceType : serviceTypes) {
                    result = CompositeCertificateProvider.append(result, (ICertificateProvider)this.createCertificateProvider(serviceType));
                }
                return result;
            }
        }
        return this.getCompleteCertificateProvider();
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected synchronized ICertificateProvider getCompleteCertificateProvider() {
        CompositeCertificateProvider certificateProvider = new CompositeCertificateProvider("trustedList-" + this.getOperatorName());
        certificateProvider.registerCertificateProvider(this.getServicesCertificateProvider());
        certificateProvider.registerCertificateProvider(this.getPointersCertificateProvider());
        return certificateProvider;
    }

    @Override
    public Date getDateIssued() {
        return this.getImpl().getSchemeInformation().getListIssueDateTime().toGregorianCalendar().getTime();
    }

    @Override
    public Date getDateNextUpdate() {
        NextUpdateType nextUpdate = this.getImpl().getSchemeInformation().getNextUpdate();
        if (nextUpdate == null) {
            return null;
        }
        XMLGregorianCalendar dateTime = nextUpdate.getDateTime();
        if (dateTime == null) {
            return null;
        }
        return dateTime.toGregorianCalendar().getTime();
    }

    @Override
    public TrustStatusListType getImpl() {
        return this.impl;
    }

    public String getLabel() {
        if (StringTools.isEmpty((String)this.getTerritory())) {
            return this.Msg.getString("TrustedList.Label", new Object[]{this.getOperatorName()});
        }
        return this.Msg.getString("TrustedList.LabelWithTerritory", new Object[]{this.getOperatorName(), this.getTerritory()});
    }

    public ILocator getLocator() {
        return this.locator;
    }

    @Override
    public String getOperatorName() {
        return LanguageTools.getLocal(this.getImpl().getSchemeInformation().getSchemeOperatorName());
    }

    protected synchronized ICertificateProvider getPointersCertificateProvider() {
        if (this.pointersCertificateProvider == null) {
            CompositeCertificateProvider certificateProvider = new CompositeCertificateProvider("trustedListPointer-" + this.getOperatorName());
            for (ITrustedListPointer tslPointer : this.getTSLPointers()) {
                certificateProvider.registerCertificateProvider((ICertificateProvider)tslPointer);
            }
            this.pointersCertificateProvider = certificateProvider;
        }
        return this.pointersCertificateProvider;
    }

    @Override
    public List<ITrustServiceProvider> getProviders() {
        if (this.providers == null) {
            this.providers = this.basicGetProviders();
        }
        return this.providers;
    }

    protected synchronized ICertificateProvider getServicesCertificateProvider() {
        if (this.servicesCertificateProvider == null) {
            CompositeCertificateProvider certificateProvider = new CompositeCertificateProvider("trustServices-" + this.getOperatorName());
            for (ITrustServiceProvider provider : this.getProviders()) {
                certificateProvider.registerCertificateProvider((ICertificateProvider)provider);
            }
            this.servicesCertificateProvider = certificateProvider;
        }
        return this.servicesCertificateProvider;
    }

    @Override
    public ISignatureContainer getSignatureContainer() throws IOException {
        return XMLSignatureContainer.createXMLSignatureContainer((ILocator)this.getLocator());
    }

    @Override
    public String getTerritory() {
        return this.getImpl().getSchemeInformation().getSchemeTerritory();
    }

    public ITrustBase getTrustBase() {
        return this.trustBase;
    }

    @Override
    public List<ITrustedListPointer> getTSLPointers() {
        if (this.tslPointers == null) {
            this.tslPointers = this.basicGetTSLPointers();
        }
        return this.tslPointers;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        ICertificateProvider certificateProvider = this.createCertificateProvider(filter);
        Iterator queryResult = certificateProvider.lookupCertificates(filter);
        ConversionIterator<IX509Certificate, IX509Certificate> result = new ConversionIterator<IX509Certificate, IX509Certificate>(queryResult){

            protected IX509Certificate createTargetObject(IX509Certificate certificate) {
                TrustBaseTools.setTrustBase((IX509Certificate)certificate, (ITrustBase)TrustedList.this.getTrustBase());
                return certificate;
            }
        };
        return result;
    }

    protected Stream<ITSPService> lookupServices(ITSPServiceSelector selector) {
        return this.getProviders().stream().flatMap(provider -> provider.lookupServices(selector));
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public String toString() {
        return "TrustedList for " + this.getTerritory() + " by " + this.getOperatorName();
    }

    private static class ServicesCertificateProvider
    implements ICertificateProvider {
        private final Stream<ITSPService> services;

        public ServicesCertificateProvider(Stream<ITSPService> services) {
            this.services = services;
        }

        public boolean containsCertificate(IX509Certificate certificate) {
            return this.services.map(service -> TrustedList.getCertificateProvider(service)).filter(certificateProvider -> certificateProvider.containsCertificate(certificate)).findAny().isPresent();
        }

        public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
            List queries = this.services.map(service -> TrustedList.getCertificateProvider(service)).map(certificateProvider -> certificateProvider.lookupCertificates(filter)).collect(Collectors.toList());
            return new NestedIterator(queries);
        }
    }
}

